"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalIpdPaymentController = void 0;
const common_1 = require("@nestjs/common");
const internal_ipd_payment_service_1 = require("./internal-ipd-payment.service");
const internal_ipd_payment_entity_1 = require("./entities/internal-ipd-payment.entity");
const auth_guard_1 = require("../auth/auth.guard");
let InternalIpdPaymentController = class InternalIpdPaymentController {
    constructor(internalIpdPaymentService) {
        this.internalIpdPaymentService = internalIpdPaymentService;
    }
    create(createInternalIpdPayment) {
        return this.internalIpdPaymentService.create(createInternalIpdPayment);
    }
    findAll(patient_id, ipd_id) {
        return this.internalIpdPaymentService.findALL(patient_id, ipd_id);
    }
    update(id, createInternalIpdPayment) {
        return this.internalIpdPaymentService.update(id, createInternalIpdPayment);
    }
    remove(id, hos_id) {
        return this.internalIpdPaymentService.remove(id, hos_id);
    }
    async findIpdPaymentDetailsSearch(patientId, ipdDetailsId, search) {
        try {
            return await this.internalIpdPaymentService.findIpdPaymentDetailsSearch(patientId, ipdDetailsId, search);
        }
        catch (error) {
            throw new Error('Failed to fetch ipd payment details');
        }
    }
    async findIpdPaymentDetails(ipd_id, patient_id, hospital_id, search, limit, page) {
        try {
            if (!ipd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'IPD ID is required',
                };
            }
            if (!patient_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'Patient ID is required',
                };
            }
            const final_out = await this.internalIpdPaymentService.findIpdPaymentDetails(ipd_id, patient_id, hospital_id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findIpdPaymentDetail(ipd_id, patient_id, search, limit, page) {
        try {
            if (!ipd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'IPD ID is required',
                };
            }
            if (!patient_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'Patient ID is required',
                };
            }
            const final_out = await this.internalIpdPaymentService.findIpdPaymentDetail(ipd_id, patient_id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    V2create(createInternalIpdPayment) {
        if (createInternalIpdPayment.payment_mode.toLocaleLowerCase() != 'cash' &&
            createInternalIpdPayment.payment_mode.toLocaleLowerCase() != 'card' &&
            createInternalIpdPayment.payment_mode.toLocaleLowerCase() !=
                'net_banking' &&
            createInternalIpdPayment.payment_mode.toLocaleLowerCase() != 'upi') {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: 'Enter Correct Payment Method',
            };
        }
        if (!createInternalIpdPayment.received_by_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
            };
        }
        if (!createInternalIpdPayment.payment_method) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createInternalIpdPayment.payment_mode.toLocaleLowerCase() == 'card' &&
            !createInternalIpdPayment.card_division &&
            !createInternalIpdPayment.card_bank_name &&
            !createInternalIpdPayment.card_type &&
            !createInternalIpdPayment.card_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createInternalIpdPayment.payment_mode.toLocaleLowerCase() ==
            'net_banking' &&
            !createInternalIpdPayment.net_banking_division &&
            !createInternalIpdPayment.net_banking_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createInternalIpdPayment.payment_mode.toLocaleLowerCase() == 'upi' &&
            !createInternalIpdPayment.upi_id &&
            !createInternalIpdPayment.upi_transaction_id &&
            !createInternalIpdPayment.upi_bank_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        return this.internalIpdPaymentService.V2create(createInternalIpdPayment);
    }
    async getIpdBalance(ipd_id) {
        try {
            if (!ipd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: process.env.IPD_VALIDATE_MESSAGE,
                };
            }
            const balanceData = await this.internalIpdPaymentService.getIpdBalanceAmount(ipd_id);
            return {
                status_code: process.env.SUCCESS_STATUS_CODE,
                status: process.env.SUCCESS_STATUS,
                message: process.env.BALANCE_FETCH_MESSAGE,
                balance_amount: balanceData.balance,
            };
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.InternalIpdPaymentController = InternalIpdPaymentController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [internal_ipd_payment_entity_1.InternalIpdPayment]),
    __metadata("design:returntype", void 0)
], InternalIpdPaymentController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('ipd_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], InternalIpdPaymentController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, internal_ipd_payment_entity_1.InternalIpdPayment]),
    __metadata("design:returntype", void 0)
], InternalIpdPaymentController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hos_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], InternalIpdPaymentController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/Search'),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Query)('ipdDetailsId')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalIpdPaymentController.prototype, "findIpdPaymentDetailsSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_ipd_payments'),
    __param(0, (0, common_1.Query)('ipd_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('hospital_id')),
    __param(3, (0, common_1.Query)('search')),
    __param(4, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(5, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], InternalIpdPaymentController.prototype, "findIpdPaymentDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v3/get_ipd_payments'),
    __param(0, (0, common_1.Query)('ipd_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('search')),
    __param(3, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(4, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], InternalIpdPaymentController.prototype, "findIpdPaymentDetail", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/v2'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [internal_ipd_payment_entity_1.InternalIpdPaymentV2]),
    __metadata("design:returntype", void 0)
], InternalIpdPaymentController.prototype, "V2create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_ipd_balance'),
    __param(0, (0, common_1.Query)('ipd_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], InternalIpdPaymentController.prototype, "getIpdBalance", null);
exports.InternalIpdPaymentController = InternalIpdPaymentController = __decorate([
    (0, common_1.Controller)('internal-ipd-payment'),
    __metadata("design:paramtypes", [internal_ipd_payment_service_1.InternalIpdPaymentService])
], InternalIpdPaymentController);
//# sourceMappingURL=internal-ipd-payment.controller.js.map