import { InternalIpdPaymentService } from './internal-ipd-payment.service';
import { InternalIpdPayment, InternalIpdPaymentV2 } from './entities/internal-ipd-payment.entity';
export declare class InternalIpdPaymentController {
    private readonly internalIpdPaymentService;
    constructor(internalIpdPaymentService: InternalIpdPaymentService);
    create(createInternalIpdPayment: InternalIpdPayment): Promise<{
        data: {
            'id ': any;
            status: string;
            messege: string;
            inserted_data: any;
        };
    }[]>;
    findAll(patient_id: number, ipd_id: number): Promise<any>;
    update(id: string, createInternalIpdPayment: InternalIpdPayment): Promise<{
        data: {
            status: string;
            message: string;
            updated_values: any;
        };
    }[]>;
    remove(id: string, hos_id: number): Promise<{
        status: string;
        message: string;
    }[]>;
    findIpdPaymentDetailsSearch(patientId: number, ipdDetailsId: number, search: string): Promise<InternalIpdPayment[]>;
    findIpdPaymentDetails(ipd_id: number, patient_id: number, hospital_id: number, search?: string, limit?: number, page?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    } | {
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/internal-ipd-payment.dto").IpdPaymentDto[];
        total: number;
    }>;
    findIpdPaymentDetail(ipd_id: number, patient_id: number, search?: string, limit?: number, page?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    } | {
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/internal-ipd-payment.dto").IpdPaymentDto[];
        total: number;
    }>;
    V2create(createInternalIpdPayment: InternalIpdPaymentV2): Promise<{
        data: {
            'id ': any;
            status: string;
            messege: string;
            inserted_data: any;
        };
    }[]> | {
        status_code: string;
        status: string;
        message: string;
    };
    getIpdBalance(ipd_id: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        balance_amount?: undefined;
    } | {
        status_code: string;
        status: string;
        message: string;
        balance_amount: string;
    }>;
}
