"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalIpdChargesController = void 0;
const common_1 = require("@nestjs/common");
const internal_ipd_charges_service_1 = require("./internal-ipd-charges.service");
const internal_ipd_charge_entity_1 = require("./entities/internal-ipd-charge.entity");
const auth_guard_1 = require("../auth/auth.guard");
let InternalIpdChargesController = class InternalIpdChargesController {
    constructor(internalIpdChargesService) {
        this.internalIpdChargesService = internalIpdChargesService;
    }
    create(InternalOpdChargeentity) {
        return this.internalIpdChargesService.create(InternalOpdChargeentity);
    }
    findAll(ipd_id, patient_id) {
        return this.internalIpdChargesService.findAll(ipd_id, patient_id);
    }
    update(id, InternalIpdChargeentity) {
        return this.internalIpdChargesService.update(id, InternalIpdChargeentity);
    }
    async remove(id, Hospital_id) {
        const deleteipdCharges = await this.internalIpdChargesService.remove(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    findcharges(id) {
        return this.internalIpdChargesService.findcharges(id);
    }
    findAmount(id) {
        return this.internalIpdChargesService.findAmount(id);
    }
    async findOpdChargesDetailsSearch(patientId, ipdDetailsId, search) {
        try {
            return await this.internalIpdChargesService.findOpdChargesDetailsSearch(patientId, ipdDetailsId, search);
        }
        catch (error) {
            throw new Error(`Failed to insert or update data: ${error.message}`);
        }
    }
    async findIpdChargeDetails(ipd_id, patient_id, search, limit, page) {
        try {
            if (!ipd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'IPD ID is required',
                };
            }
            if (!patient_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'Patient ID is required',
                };
            }
            const final_out = await this.internalIpdChargesService.findIpdChargeDetails(ipd_id, patient_id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findIpdChargeDetail(ipd_id, patient_id, search, limit, page) {
        try {
            if (!ipd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'IPD ID is required',
                };
            }
            if (!patient_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'Patient ID is required',
                };
            }
            const final_out = await this.internalIpdChargesService.findIpdChargeDetail(ipd_id, patient_id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.InternalIpdChargesController = InternalIpdChargesController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], InternalIpdChargesController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('ipd_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], InternalIpdChargesController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, internal_ipd_charge_entity_1.InternalIpdCharge]),
    __metadata("design:returntype", void 0)
], InternalIpdChargesController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], InternalIpdChargesController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/charges/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], InternalIpdChargesController.prototype, "findcharges", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/amount/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], InternalIpdChargesController.prototype, "findAmount", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/Search'),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Query)('ipdDetailsId')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], InternalIpdChargesController.prototype, "findOpdChargesDetailsSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_ipd_charges'),
    __param(0, (0, common_1.Query)('ipd_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('search')),
    __param(3, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(4, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], InternalIpdChargesController.prototype, "findIpdChargeDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v3/get_ipd_charges'),
    __param(0, (0, common_1.Query)('ipd_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('search')),
    __param(3, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(4, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], InternalIpdChargesController.prototype, "findIpdChargeDetail", null);
exports.InternalIpdChargesController = InternalIpdChargesController = __decorate([
    (0, common_1.Controller)('internal-ipd-charges'),
    __metadata("design:paramtypes", [internal_ipd_charges_service_1.InternalIpdChargesService])
], InternalIpdChargesController);
//# sourceMappingURL=internal-ipd-charges.controller.js.map