"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalAppointmentStaffService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let InternalAppointmentStaffService = class InternalAppointmentStaffService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll(date) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM staff_attendance WHERE date = ?`, [date]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.INFO,
                message: process.env.STAFF_LEAVE,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const staff = await this.connection.query(`SELECT distinct CONCAT( staff.name, ' ', staff.surname)  doctor,staff.id from staff_attendance
  left join staff on staff_attendance.staff_id = staff.id
    left join staff_roles on staff_roles.staff_id = staff.id 
  where staff_roles.role_id = 3 and staff_attendance.staff_attendance_type_id != 3 and date(staff_attendance.date) = ?`, [date]);
            return staff;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalAppointmentStaffService = InternalAppointmentStaffService;
exports.InternalAppointmentStaffService = InternalAppointmentStaffService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], InternalAppointmentStaffService);
//# sourceMappingURL=internal-appointment-staff.service.js.map