"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalAppointmentSlotService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let InternalAppointmentSlotService = class InternalAppointmentSlotService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll(staff_id, global_shift_id, date) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM doctor_shift WHERE staff_id = ? 
    and global_shift_id = ? and day = dayname(?)`, [staff_id, global_shift_id, date]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const charges = await this.connection.query(`select doctor_shift.id shift_id,doctor_shift.staff_id,doctor_shift.global_shift_id,doctor_shift.day,
    concat(start_time," - ",end_time) slot
     from doctor_shift where staff_id = ? 
    and global_shift_id = ? and day = dayname(?)`, [staff_id, global_shift_id, date]);
            return charges;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalAppointmentSlotService = InternalAppointmentSlotService;
exports.InternalAppointmentSlotService = InternalAppointmentSlotService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], InternalAppointmentSlotService);
//# sourceMappingURL=internal-appointment-slot.service.js.map