"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalAppointmentShiftService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let InternalAppointmentShiftService = class InternalAppointmentShiftService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll(staff_id) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM doctor_global_shift WHERE staff_id = ?`, [staff_id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const charges = await this.connection.query(`select global_shift.name shift_name,
      global_shift.start_time,
      global_shift.end_time,
      global_shift.id global_shift_id,
    doctor_global_shift.staff_id staff_id 
    from global_shift left join doctor_global_shift on doctor_global_shift.global_shift_id = global_shift.id
     where staff_id = ?`, [staff_id]);
            return charges;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findshift(staff_id) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM doctor_global_shift WHERE staff_id = ?`, [staff_id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const shift = await this.connection.query(`select global_shift_id,global_shift.name from doctor_global_shift 
left join global_shift ON doctor_global_shift.global_shift_id = global_shift.id
where doctor_global_shift.staff_id = ?`, [staff_id]);
            return shift;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalAppointmentShiftService = InternalAppointmentShiftService;
exports.InternalAppointmentShiftService = InternalAppointmentShiftService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], InternalAppointmentShiftService);
//# sourceMappingURL=internal-appointment-shift.service.js.map