"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalAppointmentChargesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let InternalAppointmentChargesService = class InternalAppointmentChargesService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll(staff_id) {
        const [existingRecord] = await this.connection.query(`SELECT * FROM shift_details WHERE shift_details.staff_id = ?`, [staff_id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.IDENTITY,
                message: process.env.EXISTING_RECORD,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const charges = await this.connection.query(`select shift_details.staff_id, charges.id charge_id, format((charges.standard_charge+(charges.standard_charge*((tax_category.percentage)/100))),2) amount from
  charges left join tax_category on charges.tax_category_id = tax_category.id 
  left join shift_details on shift_details.charge_id = charges.id
where shift_details.staff_id = ?`, [staff_id]);
            return charges;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.InternalAppointmentChargesService = InternalAppointmentChargesService;
exports.InternalAppointmentChargesService = InternalAppointmentChargesService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], InternalAppointmentChargesService);
//# sourceMappingURL=internal-appointment-charges.service.js.map