import { DataSource } from 'typeorm';
import { HumanResourceStaff } from './entities/human_resource_staff.entity';
import { CountDto } from './dto/human_resource_staff.dto';
export declare class HumanResourceStaffService {
    private readonly connection;
    private readonly dynamicConnection;
    constructor(connection: DataSource, dynamicConnection: DataSource);
    emailExists(email: string): Promise<boolean>;
    create(StaffEntity: HumanResourceStaff): Promise<any>;
    findAll(): Promise<HumanResourceStaff[]>;
    findOne(id: string): Promise<HumanResourceStaff | null>;
    findByRole(id: number): Promise<HumanResourceStaff | null>;
    update(id: number, StaffEntity: HumanResourceStaff): Promise<{
        status: string;
        message: string;
    } | {
        'data ': {
            status: string;
            messege: string;
            updated_values: any;
        };
    }[]>;
    disableStaff(id: number): Promise<{
        status: string;
        message: string;
    } | Error>;
    enableStaff(id: number): Promise<{
        status: string;
        message: string;
    } | Error>;
    remove(id: number, hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
    findByStaffIdNameRole(search: string): Promise<HumanResourceStaff[]>;
    updateStaffPassword(id: number, StaffEntity: HumanResourceStaff): Promise<{
        data: {
            status: string;
            message: string;
            updated_values: {
                primary_database: any;
                dynamic_hos_staff_database: any;
            };
        };
    }[]>;
    findAllDisableStaff(): Promise<HumanResourceStaff[]>;
    findByDisabledStaffRole(id: number): Promise<HumanResourceStaff | null>;
    findByDisabledStaffIdNameRole(search: string): Promise<HumanResourceStaff[]>;
    findAllStaff(limit: number, page: number): Promise<CountDto>;
    findAllStaffsearch(search: string, limit: number, page: number, role_id?: number): Promise<CountDto>;
    findAllDisabledStaff(limit: number, page: number): Promise<CountDto>;
    findAllDisabledStaffsearch(search: string, limit: number, page: number): Promise<CountDto>;
    findStaffListByRole(search: string, limit: number, page: number, role_id?: number): Promise<CountDto>;
    findDisabledStaffListByRole(search: string, limit: number, page: number, role_id?: number): Promise<CountDto>;
    findAllstaffsearch(search: string, limit: number, page: number, role_id?: number): Promise<CountDto>;
    V3findAllstaffsearch(search: string, limit: number, page: number, role_id?: number): Promise<{
        details: any;
        count: any;
    }>;
}
