"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HumanResourceStaffController = void 0;
const common_1 = require("@nestjs/common");
const human_resource_staff_service_1 = require("./human_resource_staff.service");
const human_resource_staff_entity_1 = require("./entities/human_resource_staff.entity");
const auth_guard_1 = require("../auth/auth.guard");
let HumanResourceStaffController = class HumanResourceStaffController {
    constructor(humanResourceStaffService) {
        this.humanResourceStaffService = humanResourceStaffService;
    }
    create(HumanResourceStaffEntity) {
        return this.humanResourceStaffService.create(HumanResourceStaffEntity);
    }
    findAll() {
        return this.humanResourceStaffService.findAll();
    }
    findOne(id) {
        return this.humanResourceStaffService.findOne(id);
    }
    findByRole(id) {
        return this.humanResourceStaffService.findByRole(id);
    }
    findByStaffIdNameRole(search) {
        return this.humanResourceStaffService.findByStaffIdNameRole(search);
    }
    update(id, HumanResourceStaffENTITY) {
        return this.humanResourceStaffService.update(id, HumanResourceStaffENTITY);
    }
    updateStaffPassword(id, HumanResourceStaffENTITY) {
        return this.humanResourceStaffService.updateStaffPassword(id, HumanResourceStaffENTITY);
    }
    async disableStaff(id) {
        return this.humanResourceStaffService.disableStaff(id);
    }
    async enableStaff(id) {
        return this.humanResourceStaffService.enableStaff(id);
    }
    async removeStaff(id, hospital_id) {
        await this.humanResourceStaffService.remove(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    findAllDisableStaff() {
        return this.humanResourceStaffService.findAllDisableStaff();
    }
    findByDisabledStaffRole(id) {
        return this.humanResourceStaffService.findByDisabledStaffRole(id);
    }
    findByDisabledStaffIdNameRole(search) {
        return this.humanResourceStaffService.findByDisabledStaffIdNameRole(search);
    }
    async findAllStaff(limit, page) {
        try {
            let final_out = await this.humanResourceStaffService.findAllStaff(limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findAllStaffsearch(search, limit, page, role_id) {
        try {
            let final_out = await this.humanResourceStaffService.findAllStaffsearch(search, limit || 10, page || 1, role_id);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findAllDisabledStaff(limit, page) {
        try {
            let final_out = await this.humanResourceStaffService.findAllDisabledStaff(limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findAllDisabledStaffsearch(search, limit, page) {
        try {
            let final_out = await this.humanResourceStaffService.findAllDisabledStaffsearch(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findStaffListByRole(search, limit, page, role_id) {
        try {
            const pageNum = Number(page) || 1;
            const limitNum = Number(limit) || 10;
            const roleId = Number(role_id);
            const final_output = await this.humanResourceStaffService.findStaffListByRole(search, limitNum, pageNum, roleId);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                };
            }
            return {
                status_code: process.env.SUCCESS_STATUS_CODE,
                status: process.env.SUCCESS_STATUS,
                message: 'No staff found for the provided role.',
                data: [],
                total: 0,
            };
        }
        catch (error) {
            console.error('Error in get_staff_list_by_role:', error);
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findDisabledStaffListByRole(search, limit, page, role_id) {
        try {
            const final_output = await this.humanResourceStaffService.findDisabledStaffListByRole(search, limit || 10, page || 1, role_id);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                };
            }
            return {
                status_code: process.env.SUCCESS_STATUS_CODE,
                status: process.env.SUCCESS_STATUS,
                message: process.env.DATA_NOT_FOUND,
                data: [],
                total: 0,
            };
        }
        catch (error) {
            console.error('Error in get_disabled_staff_list_by_role:', error);
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findAllstaffsearch(search, limit, page, role_id) {
        try {
            let final_out = await this.humanResourceStaffService.findAllstaffsearch(search, limit || 10, page || 1, role_id);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async V3findAllstaffsearch(search, limit, page, role_id) {
        try {
            let final_out = await this.humanResourceStaffService.V3findAllstaffsearch(search, limit || 10, page || 1, role_id);
            return final_out;
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.HumanResourceStaffController = HumanResourceStaffController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [human_resource_staff_entity_1.HumanResourceStaff]),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/role/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "findByRole", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "findByStaffIdNameRole", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, human_resource_staff_entity_1.HumanResourceStaff]),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/password/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, human_resource_staff_entity_1.HumanResourceStaff]),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "updateStaffPassword", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('disable/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "disableStaff", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('enable/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "enableStaff", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "removeStaff", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/disabled/staff'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "findAllDisableStaff", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/disabled/role/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "findByDisabledStaffRole", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/disabledStaff/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], HumanResourceStaffController.prototype, "findByDisabledStaffIdNameRole", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_all_staff_list'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "findAllStaff", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_staff_search_list'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('role_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "findAllStaffsearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_all_disabled_staff_list'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "findAllDisabledStaff", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_disabled_staff_search_list'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "findAllDisabledStaffsearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_staff_list_by_role'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('role_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "findStaffListByRole", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_disabled_staff_list_by_role'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('role_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "findDisabledStaffListByRole", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v3/get_staff_search_list'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('role_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "findAllstaffsearch", null);
__decorate([
    (0, common_1.Get)('/v3/get_staff_search_list_new'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('role_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceStaffController.prototype, "V3findAllstaffsearch", null);
exports.HumanResourceStaffController = HumanResourceStaffController = __decorate([
    (0, common_1.Controller)('human-resource-staff'),
    __metadata("design:paramtypes", [human_resource_staff_service_1.HumanResourceStaffService])
], HumanResourceStaffController);
//# sourceMappingURL=human_resource_staff.controller.js.map