import { HumanResourceStaffService } from './human_resource_staff.service';
import { HumanResourceStaff } from './entities/human_resource_staff.entity';
export declare class HumanResourceStaffController {
    private readonly humanResourceStaffService;
    constructor(humanResourceStaffService: HumanResourceStaffService);
    create(HumanResourceStaffEntity: HumanResourceStaff): Promise<any>;
    findAll(): Promise<HumanResourceStaff[]>;
    findOne(id: string): Promise<HumanResourceStaff>;
    findByRole(id: number): Promise<HumanResourceStaff>;
    findByStaffIdNameRole(search: string): Promise<HumanResourceStaff[]>;
    update(id: number, HumanResourceStaffENTITY: HumanResourceStaff): Promise<{
        status: string;
        message: string;
    } | {
        'data ': {
            status: string;
            messege: string;
            updated_values: any;
        };
    }[]>;
    updateStaffPassword(id: number, HumanResourceStaffENTITY: HumanResourceStaff): Promise<{
        data: {
            status: string;
            message: string;
            updated_values: {
                primary_database: any;
                dynamic_hos_staff_database: any;
            };
        };
    }[]>;
    disableStaff(id: number): Promise<Error | {
        status: string;
        message: string;
    }>;
    enableStaff(id: number): Promise<Error | {
        status: string;
        message: string;
    }>;
    removeStaff(id: number, hospital_id: number): Promise<{
        status: string;
        message: string;
    }>;
    findAllDisableStaff(): Promise<HumanResourceStaff[]>;
    findByDisabledStaffRole(id: number): Promise<HumanResourceStaff>;
    findByDisabledStaffIdNameRole(search: string): Promise<HumanResourceStaff[]>;
    findAllStaff(limit?: number, page?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/human_resource_staff.dto").StaffDto[];
        total: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    }>;
    findAllStaffsearch(search?: string, limit?: number, page?: number, role_id?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/human_resource_staff.dto").StaffDto[];
        total: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    }>;
    findAllDisabledStaff(limit?: number, page?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/human_resource_staff.dto").StaffDto[];
        total: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    }>;
    findAllDisabledStaffsearch(search?: string, limit?: number, page?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/human_resource_staff.dto").StaffDto[];
        total: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    }>;
    findStaffListByRole(search: string, limit: number, page: number, role_id?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/human_resource_staff.dto").StaffDto[];
        total: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    }>;
    findDisabledStaffListByRole(search?: string, limit?: number, page?: number, role_id?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/human_resource_staff.dto").StaffDto[];
        total: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    }>;
    findAllstaffsearch(search?: string, limit?: number, page?: number, role_id?: number): Promise<{
        status_code: string;
        status: string;
        message: string;
        data: import("./dto/human_resource_staff.dto").StaffDto[];
        total: number;
    } | {
        status_code: string;
        status: string;
        message: string;
        data?: undefined;
        total?: undefined;
    }>;
    V3findAllstaffsearch(search?: string, limit?: number, page?: number, role_id?: number): Promise<{
        details: any;
        count: any;
    } | {
        status_code: string;
        status: string;
        message: string;
    }>;
}
