import { DataSource } from 'typeorm';
import { HumanResourcePayroll } from './entities/human_resource_payroll.entity';
export declare class HumanResourcePayrollService {
    private readonly connection;
    private readonly dynamicConnection;
    constructor(connection: DataSource, dynamicConnection: DataSource);
    create(createHumanResourcePayroll: HumanResourcePayroll): Promise<{
        data: {
            status: string;
            messege: string;
            Added_Staff_Payslip_details: any;
        };
    }[]>;
    getStaffPayrollList(filters: any): Promise<any>;
    update(id: number, createHumanResourcePayroll: HumanResourcePayroll): Promise<{
        status: string;
        message: string;
        updated_values: any;
    }>;
    revertPayslip(id: number, hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
    updatePaidrevertStatus(id: number, hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
    proceedToPay(id: number, createHumanResourcePayroll: HumanResourcePayroll): Promise<{
        'data ': {
            status: string;
            messege: string;
            updated_values: any;
        };
    }[]>;
    findOne(id: string): Promise<HumanResourcePayroll | null>;
    StaffPayrollListByRoleMonthYear(date: Date, roleId: number, search: string, limit: number, page: number): Promise<{
        details: any;
        total: any;
    }>;
    removePayslipAllowance(id: number, Hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
    getMonthName(monthNumber: any): Promise<string>;
}
