"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HumanResourcePayrollController = void 0;
const common_1 = require("@nestjs/common");
const human_resource_payroll_service_1 = require("./human_resource_payroll.service");
const human_resource_payroll_entity_1 = require("./entities/human_resource_payroll.entity");
const auth_guard_1 = require("../auth/auth.guard");
let HumanResourcePayrollController = class HumanResourcePayrollController {
    constructor(humanResourcePayrollService) {
        this.humanResourcePayrollService = humanResourcePayrollService;
    }
    create(createHumanResourcePayroll) {
        return this.humanResourcePayrollService.create(createHumanResourcePayroll);
    }
    async getStaffPayrollList(filters) {
        try {
            const getStaffPayroll = await this.humanResourcePayrollService.getStaffPayrollList(filters);
            return getStaffPayroll;
        }
        catch (error) {
            console.error(error);
        }
    }
    update(id, createHumanResourcePayroll) {
        return this.humanResourcePayrollService.update(+id, createHumanResourcePayroll);
    }
    async revertPayslip(id, hospital_id) {
        await this.humanResourcePayrollService.revertPayslip(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    updatePaidrevertStatus(id, hospital_id) {
        return this.humanResourcePayrollService.updatePaidrevertStatus(+id, hospital_id);
    }
    proceedToPay(id, createHumanResourcePayroll) {
        return this.humanResourcePayrollService.proceedToPay(+id, createHumanResourcePayroll);
    }
    findOne(id) {
        return this.humanResourcePayrollService.findOne(id);
    }
    async StaffPayrollListByRoleMonthYear(search, limit, page, year, month, role) {
        try {
            const limitNum = Number(limit) || 10;
            const pageNum = Number(page) || 1;
            const roleId = Number(role) || null;
            if (!year ||
                !month ||
                isNaN(year) ||
                isNaN(month) ||
                month < 1 ||
                month > 12) {
                return {
                    status_code: process.env.ERROR_STATUS_CODE,
                    status: process.env.ERROR_STATUS,
                    message: 'Invalid or missing year/month provided.',
                };
            }
            const attendanceDate = new Date(year, month - 1, 1);
            const final_output = await this.humanResourcePayrollService.StaffPayrollListByRoleMonthYear(attendanceDate, roleId, search, limitNum, pageNum);
            return {
                status_code: process.env.SUCCESS_STATUS_CODE,
                status: process.env.SUCCESS_STATUS,
                message: final_output.details.length > 0
                    ? process.env.SUCCESS_MESSAGE
                    : 'No staff found for the provided filters.',
                data: final_output.details,
                total: final_output.total,
            };
        }
        catch (error) {
            console.error('Error in get_staff_payroll_list_by_role_month_year:', error);
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async removePayslipAllowance(id, Hospital_id) {
        await this.humanResourcePayrollService.removePayslipAllowance(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.HumanResourcePayrollController = HumanResourcePayrollController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [human_resource_payroll_entity_1.HumanResourcePayroll]),
    __metadata("design:returntype", void 0)
], HumanResourcePayrollController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], HumanResourcePayrollController.prototype, "getStaffPayrollList", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, human_resource_payroll_entity_1.HumanResourcePayroll]),
    __metadata("design:returntype", void 0)
], HumanResourcePayrollController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourcePayrollController.prototype, "revertPayslip", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/revertPaidPayslip/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], HumanResourcePayrollController.prototype, "updatePaidrevertStatus", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/ProceedToPay/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, human_resource_payroll_entity_1.HumanResourcePayroll]),
    __metadata("design:returntype", void 0)
], HumanResourcePayrollController.prototype, "proceedToPay", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/getCalculatedSalary/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], HumanResourcePayrollController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_staff_payroll_list_by_role_month_year'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('year')),
    __param(4, (0, common_1.Query)('month')),
    __param(5, (0, common_1.Query)('role')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourcePayrollController.prototype, "StaffPayrollListByRoleMonthYear", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/delete/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourcePayrollController.prototype, "removePayslipAllowance", null);
exports.HumanResourcePayrollController = HumanResourcePayrollController = __decorate([
    (0, common_1.Controller)('human-resource-payroll'),
    __metadata("design:paramtypes", [human_resource_payroll_service_1.HumanResourcePayrollService])
], HumanResourcePayrollController);
//# sourceMappingURL=human_resource_payroll.controller.js.map