import { DataSource } from 'typeorm';
import { HumanResourceApplyLeave } from './entities/human_resource_apply_leave.entity';
import { CountDto } from './dto/human_resource_apply_leave.dto';
export declare class HumanResourceApplyLeaveService {
    private readonly connection;
    private readonly dynamicConnection;
    constructor(connection: DataSource, dynamicConnection: DataSource);
    create(createHumanResourceApplyLeave: HumanResourceApplyLeave): Promise<{
        data: {
            status: string;
            messege: string;
            Added_Staff_leave_details: any;
        };
    }[]>;
    findAll(): Promise<HumanResourceApplyLeave[]>;
    remove(id: number, hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
    createLeaveRequest(createHumanResourceApplyLeaveRequest: HumanResourceApplyLeave): Promise<{
        data: {
            status: string;
            messege: string;
            Added_Staff_leave_details: any;
        };
    }[]>;
    findAllLeaveRequest(): Promise<HumanResourceApplyLeave[]>;
    updateStaffLeaveRequest(id: number, updateHumanResourceApplyLeave: HumanResourceApplyLeave): Promise<{
        data: {
            status: string;
            message: string;
            updated_values: {
                primary_database: any;
                dynamic_database: any;
            };
        };
    }[]>;
    findByOwnStaffLeaveDetails(search: string): Promise<HumanResourceApplyLeave[]>;
    findByAdminStaffLeaveDetails(search: string): Promise<HumanResourceApplyLeave[]>;
    findRoles(): Promise<HumanResourceApplyLeave[]>;
    listStaffByRole(id: number): Promise<HumanResourceApplyLeave | null>;
    listStaffLeavesByStaffID(id: number): Promise<HumanResourceApplyLeave | null>;
    findStaffOwnLeaveRequestDetails(search: string, limit: number, page: number, staffId?: number): Promise<CountDto>;
    findStaffLeaveRequestDetails(search: string, limit: number, page: number): Promise<CountDto>;
}
