"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HumanResourceApplyLeaveController = void 0;
const common_1 = require("@nestjs/common");
const human_resource_apply_leave_service_1 = require("./human_resource_apply_leave.service");
const human_resource_apply_leave_entity_1 = require("./entities/human_resource_apply_leave.entity");
const auth_guard_1 = require("../auth/auth.guard");
let HumanResourceApplyLeaveController = class HumanResourceApplyLeaveController {
    constructor(humanResourceApplyLeaveService) {
        this.humanResourceApplyLeaveService = humanResourceApplyLeaveService;
    }
    create(createHumanResourceApplyLeave) {
        return this.humanResourceApplyLeaveService.create(createHumanResourceApplyLeave);
    }
    findAll() {
        return this.humanResourceApplyLeaveService.findAll();
    }
    async removeStaffLeave(id, hospital_id) {
        await this.humanResourceApplyLeaveService.remove(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    createLeaveRequest(createHumanResourceApplyLeaveRequest) {
        return this.humanResourceApplyLeaveService.createLeaveRequest(createHumanResourceApplyLeaveRequest);
    }
    findAllLeaveRequest() {
        return this.humanResourceApplyLeaveService.findAllLeaveRequest();
    }
    updateStaffLeaveRequest(id, updateHumanResourceApplyLeave) {
        return this.humanResourceApplyLeaveService.updateStaffLeaveRequest(id, updateHumanResourceApplyLeave);
    }
    findByOwnStaffLeaveDetails(search) {
        return this.humanResourceApplyLeaveService.findByOwnStaffLeaveDetails(search);
    }
    findByAdminStaffLeaveDetails(search) {
        return this.humanResourceApplyLeaveService.findByAdminStaffLeaveDetails(search);
    }
    findRoles() {
        return this.humanResourceApplyLeaveService.findRoles();
    }
    listStaffByRole(id) {
        return this.humanResourceApplyLeaveService.listStaffByRole(id);
    }
    listStallLeavesByStaffID(id) {
        return this.humanResourceApplyLeaveService.listStaffLeavesByStaffID(id);
    }
    async findStaffOwnLeaveRequestDetails(search, limit = 10, page = 1, staffId) {
        try {
            const final_out = await this.humanResourceApplyLeaveService.findStaffOwnLeaveRequestDetails(search, limit, page, staffId);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findStaffLeaveRequestDetails(search, limit, page) {
        try {
            let final_out = await this.humanResourceApplyLeaveService.findStaffLeaveRequestDetails(search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.HumanResourceApplyLeaveController = HumanResourceApplyLeaveController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [human_resource_apply_leave_entity_1.HumanResourceApplyLeave]),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceApplyLeaveController.prototype, "removeStaffLeave", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/addLeaveRequest'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [human_resource_apply_leave_entity_1.HumanResourceApplyLeave]),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "createLeaveRequest", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/addLeaveRequest'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "findAllLeaveRequest", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/addLeaveRequest/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, human_resource_apply_leave_entity_1.HumanResourceApplyLeave]),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "updateStaffLeaveRequest", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "findByOwnStaffLeaveDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/AdminStaffkeyword/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "findByAdminStaffLeaveDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/listRoles'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "findRoles", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/listStaffByRole/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "listStaffByRole", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/listStaffLeavesByStaffID/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], HumanResourceApplyLeaveController.prototype, "listStallLeavesByStaffID", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_staff_own_leave_request_details'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('staffId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceApplyLeaveController.prototype, "findStaffOwnLeaveRequestDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_staff_leave_request_details'),
    __param(0, (0, common_1.Query)('search')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], HumanResourceApplyLeaveController.prototype, "findStaffLeaveRequestDetails", null);
exports.HumanResourceApplyLeaveController = HumanResourceApplyLeaveController = __decorate([
    (0, common_1.Controller)('human-resource-apply-leave'),
    __metadata("design:paramtypes", [human_resource_apply_leave_service_1.HumanResourceApplyLeaveService])
], HumanResourceApplyLeaveController);
//# sourceMappingURL=human_resource_apply_leave.controller.js.map