"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HospitalsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const qr_encrpyt_service_1 = require("../qr-encrpyt/qr-encrpyt.service");
let HospitalsService = class HospitalsService {
    constructor(connection, dynamicConnection, EncryptedService) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
        this.EncryptedService = EncryptedService;
    }
    async findOne(id) {
        try {
            const hospitals = await this.dynamicConnection.query(`SELECT * FROM hospitals WHERE plenome_id = ?`, [id]);
            return hospitals;
        }
        catch (error) {
            return error;
        }
    }
    async findoneQR(id) {
        try {
            const [getall] = await this.dynamicConnection.query(`select hospitals.plenome_id as hospital_id, hospitals.HealthFacilityID,hospitals.hospital_name,
    hospitals.contact_no,hospitals.hospital_consulting_charge,hospitals.hospital_opening_timing,
    hospitals.hospital_closing_timing,hospitals.address,hospitals.state,hospitals.district,hospitals.pincode,
    hospitals.website,hospitals.email,hospitals.hospital_reg_no,hospitals.hospital_reg_date,hospitals.hospital_reg_expiry_date,
    hospitals.specialty,hospitals.image,hospitals.logo,hospitals.bedcount,hospitals.overview,hospitals.created_at,
    hospitals.tax_percentage,hospitals.tax_amount,hospitals.lattitude,hospitals.longitude from hospitals WHERE plenome_id = ?`, [id]);
            let resp = {
                QR_type_id: 1,
                QR_type: 'HospitalQR',
                hospitals: getall,
            };
            return resp;
        }
        catch (error) {
            return error;
        }
    }
    async EncryptedfindoneQR(id) {
        try {
            const [getall] = await this.dynamicConnection.query(`select hospitals.plenome_id as hospital_id from hospitals WHERE plenome_id = ?`, [id]);
            let resp = {
                QR_type_id: 1,
                QR_type: 'HospitalQR',
                hospitals_id: getall?.hospital_id,
            };
            const encrypt_apicall = await this.EncryptedService.encrypt(JSON.stringify(resp), process.env.encryption_key, process.env.encryption_iv);
            return encrypt_apicall;
        }
        catch (error) {
            return error;
        }
    }
    async update(id, HospitalEntity) {
        try {
            await this.dynamicConnection.query(`update hospitals SET hospital_name = ?,
          contact_no = ?,
          hospital_consulting_charge = ?,
          hospital_opening_timing = ?,
          hospital_closing_timing = ?,
          address = ?,
          state = ?,
          district = ?,
          pincode = ?,
          website = ?,
          email = ?,
          hospital_reg_no = ?,
      hospital_reg_date = ?,
      hospital_reg_expiry_date = ?,
      specialty = ?,
      image = ?,
      logo = ?,
      bedcount = ?,
      overview = ?
   where plenome_id = ?
          `, [
                HospitalEntity.hospital_name,
                HospitalEntity.contact_no,
                HospitalEntity.hospital_consulting_charge,
                HospitalEntity.hospital_opening_timing,
                HospitalEntity.hospital_closing_timing,
                HospitalEntity.address,
                HospitalEntity.state,
                HospitalEntity.district,
                HospitalEntity.pincode,
                HospitalEntity.website,
                HospitalEntity.email,
                HospitalEntity.hospital_reg_no,
                HospitalEntity.hospital_reg_date,
                HospitalEntity.hospital_reg_expiry_date,
                JSON.stringify(HospitalEntity.specialty),
                HospitalEntity.image,
                HospitalEntity.logo,
                HospitalEntity.bedcount,
                HospitalEntity.overview,
                id,
            ]);
            return [
                {
                    data: {
                        status: 'success',
                        message: 'hospitals details updated successfully',
                        updated_values: await this.dynamicConnection.query(`select * from hospitals where plenome_id = ?`, [id]),
                    },
                },
            ];
        }
        catch (error) {
            return [
                {
                    status: 'failed',
                    messege: 'cannot update hospitals profile',
                    error: error,
                },
            ];
        }
    }
};
exports.HospitalsService = HospitalsService;
exports.HospitalsService = HospitalsService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __param(2, (0, common_1.Inject)((0, common_1.forwardRef)(() => qr_encrpyt_service_1.CryptoService))),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        qr_encrpyt_service_1.CryptoService])
], HospitalsService);
//# sourceMappingURL=hospitals.service.js.map