"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HospitalChargesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let HospitalChargesService = class HospitalChargesService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async update(id, hos_chargesEntity) {
        try {
            const check = await this.dynamicConnection.query(`select hospital_consulting_charge from hospitals where plenome_id = ?`, [hos_chargesEntity.hospital_id]);
            if (check) {
                if ((hos_chargesEntity.hospital_consulting_charge || hos_chargesEntity.tax_percentage || hos_chargesEntity.tax_amount) == "") {
                    return {
                        "status": "failed",
                        "message": "enter all the necessary values to update",
                    };
                }
                else {
                    await this.dynamicConnection.query(`
    update hospitals set
    hospital_consulting_charge = ?,
    tax_percentage = ?,
    tax_amount = ?
    where plenome_id = ?`, [
                        hos_chargesEntity.hospital_consulting_charge,
                        hos_chargesEntity.tax_percentage,
                        hos_chargesEntity.tax_amount,
                        hos_chargesEntity.hospital_id
                    ]);
                    return {
                        "status": "success",
                        "message": "hospitals details updated successfully",
                    };
                }
            }
            else {
                return {
                    "status": "failed",
                    "message": "Enter correct hospital_id to set charges",
                };
            }
        }
        catch (error) {
            return error;
        }
    }
    async findall(plenome_id) {
        try {
            const hospital = await this.dynamicConnection.query(`   SELECT
    hospitals .plenome_id,
    hospitals.hospital_name,
   hospitals.hospital_consulting_charge,
   hospitals.tax_percentage,
   hospitals.tax_amount,
      concat((hospitals.hospital_consulting_charge + (hospitals.hospital_consulting_charge * (hospitals.tax_percentage/100)))) as amount
  FROM
     hospitals
  WHERE
  plenome_id = ?;`, [plenome_id]);
            return hospital;
        }
        catch (error) {
            return error;
        }
    }
};
exports.HospitalChargesService = HospitalChargesService;
exports.HospitalChargesService = HospitalChargesService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], HospitalChargesService);
//# sourceMappingURL=hospital_charges.service.js.map