"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontofficeComplainService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let FrontofficeComplainService = class FrontofficeComplainService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createFrontofficeComplain) {
        try {
            const addComplaint = await this.connection.query(`INSERT into complaint(
       complaint_type_id,
       source,
       name,
       contact,
       email,
       date,
       description,
       action_taken,
       assigned,
       note,
       image
        ) VALUES (?,?,?,?,?,?,?,?,?,?,?)`, [
                createFrontofficeComplain.complaint_type_id,
                createFrontofficeComplain.source,
                createFrontofficeComplain.name,
                createFrontofficeComplain.contact,
                createFrontofficeComplain.email,
                createFrontofficeComplain.date,
                createFrontofficeComplain.description,
                createFrontofficeComplain.action_taken,
                createFrontofficeComplain.assigned,
                createFrontofficeComplain.note,
                createFrontofficeComplain.image
            ]);
            const addComplaintID = addComplaint.insertId;
            await this.dynamicConnection.query(`INSERT into complaint(
       complaint_type_id,
       source,
       name,
       contact,
       email,
       date,
       description,
       action_taken,
       assigned,
       note,
       image,
       hospital_id,
       hos_complaint_id
          ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)`, [
                createFrontofficeComplain.complaint_type_id,
                createFrontofficeComplain.source,
                createFrontofficeComplain.name,
                createFrontofficeComplain.contact,
                createFrontofficeComplain.email,
                createFrontofficeComplain.date,
                createFrontofficeComplain.description,
                createFrontofficeComplain.action_taken,
                createFrontofficeComplain.assigned,
                createFrontofficeComplain.note,
                createFrontofficeComplain.image,
                createFrontofficeComplain.hospital_id,
                addComplaintID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Complaint added successfully ",
                        "complaint_Details": await this.connection.query('SELECT * FROM complaint WHERE id = ?', [addComplaintID])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async update(id, createFrontofficeComplain) {
        try {
            await this.connection.query(`update complaint SET
       complaint_type_id=?,
       source=?,
       name=?,
       contact=?,
       email=?,
       date=?,
       description=?,
       action_taken=?,
       assigned=?,
       note=?,
       image=?
       where id=?`, [
                createFrontofficeComplain.complaint_type_id,
                createFrontofficeComplain.source,
                createFrontofficeComplain.name,
                createFrontofficeComplain.contact,
                createFrontofficeComplain.email,
                createFrontofficeComplain.date,
                createFrontofficeComplain.description,
                createFrontofficeComplain.action_taken,
                createFrontofficeComplain.assigned,
                createFrontofficeComplain.note,
                createFrontofficeComplain.image,
                id
            ]);
            const [dynCallLogs] = await this.dynamicConnection.query(`select id from complaint where hospital_id = ? and  hos_complaint_id = ?`, [createFrontofficeComplain.hospital_id, id]);
            const dynCallLogsID = dynCallLogs.id;
            await this.dynamicConnection.query(`update complaint SET
       complaint_type_id=?,
       source=?,
       name=?,
       contact=?,
       email=?,
       date=?,
       description=?,
       action_taken=?,
       assigned=?,
       note=?,
       image=?,
       hospital_id=?
       where id=?`, [
                createFrontofficeComplain.complaint_type_id,
                createFrontofficeComplain.source,
                createFrontofficeComplain.name,
                createFrontofficeComplain.contact,
                createFrontofficeComplain.email,
                createFrontofficeComplain.date,
                createFrontofficeComplain.description,
                createFrontofficeComplain.action_taken,
                createFrontofficeComplain.assigned,
                createFrontofficeComplain.note,
                createFrontofficeComplain.image,
                createFrontofficeComplain.hospital_id,
                dynCallLogsID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Complaint updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM complaint WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async removeFrontofficeComplaint(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM complaint WHERE id = ?', [id]);
            await this.dynamicConnection.query('DELETE FROM complaint WHERE hos_complaint_id = ? and hospital_id = ?', [id, hospital_id]);
            return [
                {
                    status: 'success',
                    message: `Complaint details with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
};
exports.FrontofficeComplainService = FrontofficeComplainService;
exports.FrontofficeComplainService = FrontofficeComplainService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], FrontofficeComplainService);
//# sourceMappingURL=frontoffice_complain.service.js.map