"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontCmsPageService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let FrontCmsPageService = class FrontCmsPageService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createFrontCmsPage) {
        try {
            if (createFrontCmsPage.page_type === 'standard') {
                let front_cms_page_id;
                const frontcmspage = await this.connection.query(`INSERT into front_cms_pages (
page_type,
is_homepage,
title,
url,
type,
slug,
meta_title,
meta_description,
meta_keyword,
feature_image,
description,
publish_date,
publish,
sidebar,
is_active
           ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createFrontCmsPage.page_type,
                    createFrontCmsPage.is_homepage,
                    createFrontCmsPage.title,
                    createFrontCmsPage.url,
                    'page',
                    createFrontCmsPage.slug,
                    createFrontCmsPage.meta_title,
                    createFrontCmsPage.meta_description,
                    createFrontCmsPage.meta_keyword,
                    createFrontCmsPage.feature_image,
                    createFrontCmsPage.description,
                    createFrontCmsPage.publish_date,
                    0,
                    createFrontCmsPage.sidebar,
                    'no'
                ]);
                front_cms_page_id = frontcmspage.insertId;
                await this.dynamicConnection.query(`INSERT into front_cms_pages (
page_type,
is_homepage,
title,
url,
type,
slug,
meta_title,
meta_description,
meta_keyword,
feature_image,
description,
publish_date,
publish,
sidebar,
is_active,
hospital_id,
hos_front_cms_pages_id
           ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createFrontCmsPage.page_type,
                    createFrontCmsPage.is_homepage,
                    createFrontCmsPage.title,
                    createFrontCmsPage.url,
                    'page',
                    createFrontCmsPage.slug,
                    createFrontCmsPage.meta_title,
                    createFrontCmsPage.meta_description,
                    createFrontCmsPage.meta_keyword,
                    createFrontCmsPage.feature_image,
                    createFrontCmsPage.description,
                    createFrontCmsPage.publish_date,
                    0,
                    createFrontCmsPage.sidebar,
                    'no',
                    createFrontCmsPage.hospital_id,
                    front_cms_page_id
                ]);
            }
            else {
                let front_cms_page_id;
                const frontcmspage = await this.connection.query(`INSERT into front_cms_pages (
      page_type,
      is_homepage,
      title,
      url,
      type,
      slug,
      meta_title,
      meta_description,
      meta_keyword,
      feature_image,
      description,
      publish_date,
      publish,
      sidebar,
      is_active
                 ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createFrontCmsPage.page_type,
                    createFrontCmsPage.is_homepage,
                    createFrontCmsPage.title,
                    createFrontCmsPage.url,
                    'page',
                    createFrontCmsPage.slug,
                    createFrontCmsPage.meta_title,
                    createFrontCmsPage.meta_description,
                    createFrontCmsPage.meta_keyword,
                    createFrontCmsPage.feature_image,
                    createFrontCmsPage.description,
                    createFrontCmsPage.publish_date,
                    0,
                    createFrontCmsPage.sidebar,
                    'no'
                ]);
                front_cms_page_id = frontcmspage.insertId;
                let front_cms_page_contents_id;
                const frontcmspagecontents = await this.connection.query(`INSERT into front_cms_page_contents (
           page_id,
           content_type
                      ) VALUES (?,?)`, [front_cms_page_id,
                    createFrontCmsPage.page_type
                ]);
                front_cms_page_contents_id = frontcmspagecontents.insertId;
                let Dyn_fron_cms_pages_id;
                const DynFrontCMSPage = await this.dynamicConnection.query(`INSERT into front_cms_pages (
      page_type,
      is_homepage,
      title,
      url,
      type,
      slug,
      meta_title,
      meta_description,
      meta_keyword,
      feature_image,
      description,
      publish_date,
      publish,
      sidebar,
      is_active,
      hospital_id,
      hos_front_cms_pages_id
                 ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createFrontCmsPage.page_type,
                    createFrontCmsPage.is_homepage,
                    createFrontCmsPage.title,
                    createFrontCmsPage.url,
                    'page',
                    createFrontCmsPage.slug,
                    createFrontCmsPage.meta_title,
                    createFrontCmsPage.meta_description,
                    createFrontCmsPage.meta_keyword,
                    createFrontCmsPage.feature_image,
                    createFrontCmsPage.description,
                    createFrontCmsPage.publish_date,
                    0,
                    createFrontCmsPage.sidebar,
                    'no',
                    createFrontCmsPage.hospital_id,
                    front_cms_page_id
                ]);
                Dyn_fron_cms_pages_id = DynFrontCMSPage.insertId;
                await this.dynamicConnection.query(`INSERT into front_cms_page_contents (
           page_id,
           content_type,
           hospital_id,
           hos_front_cms_page_contents_id
                      ) VALUES (?,?,?,?)`, [Dyn_fron_cms_pages_id,
                    createFrontCmsPage.page_type,
                    createFrontCmsPage.hospital_id,
                    front_cms_page_contents_id
                ]);
            }
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS page details added successfully "
                    }
                }];
        }
        catch (error) {
            console.error('Error inserting data:', error);
        }
    }
    async removeFrontCMSPage(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM front_cms_pages WHERE id = ?', [id]);
            await this.connection.query('DELETE FROM front_cms_page_contents WHERE page_id = ?', [id]);
            const [GetDyncmspageid] = await this.dynamicConnection.query('SELECT id FROM front_cms_pages WHERE hos_front_cms_pages_id=? and hospital_id=?', [id, hospital_id]);
            const Get_Dyn_front_cms_pages_ID = GetDyncmspageid.id;
            await this.dynamicConnection.query('DELETE FROM front_cms_pages WHERE id = ?', [Get_Dyn_front_cms_pages_ID]);
            await this.dynamicConnection.query('DELETE FROM front_cms_page_contents WHERE page_id = ?', [Get_Dyn_front_cms_pages_ID]);
            return [
                {
                    status: 'success',
                    message: `Front CMS page with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async updateFrontCMSPage(id, createFrontCmsPage) {
        try {
            if (createFrontCmsPage.page_type === 'standard') {
                await this.connection.query(`update front_cms_pages SET 
      page_type=?,
      title=?,
      url=?,
      slug=?,
      meta_title=?,
      meta_description=?,
      meta_keyword=?,
      feature_image=?,
      description=?,
      sidebar=?
      where id=?`, [createFrontCmsPage.page_type,
                    createFrontCmsPage.title,
                    createFrontCmsPage.url,
                    createFrontCmsPage.slug,
                    createFrontCmsPage.meta_title,
                    createFrontCmsPage.meta_description,
                    createFrontCmsPage.meta_keyword,
                    createFrontCmsPage.feature_image,
                    createFrontCmsPage.description,
                    createFrontCmsPage.sidebar,
                    id
                ]);
                const dynfrontCMSpage = await this.dynamicConnection.query('SELECT id FROM front_cms_pages WHERE hos_front_cms_pages_id=? and hospital_id=?', [id, createFrontCmsPage.hospital_id]);
                const dynfrontCMSpageID = dynfrontCMSpage[0].id;
                await this.dynamicConnection.query(`update front_cms_pages SET 
      page_type=?,
      title=?,
      url=?,
      slug=?,
      meta_title=?,
      meta_description=?,
      meta_keyword=?,
      feature_image=?,
      description=?,
      sidebar=?,
      hospital_id=?
      where id=?`, [createFrontCmsPage.page_type,
                    createFrontCmsPage.title,
                    createFrontCmsPage.url,
                    createFrontCmsPage.slug,
                    createFrontCmsPage.meta_title,
                    createFrontCmsPage.meta_description,
                    createFrontCmsPage.meta_keyword,
                    createFrontCmsPage.feature_image,
                    createFrontCmsPage.description,
                    createFrontCmsPage.sidebar,
                    createFrontCmsPage.hospital_id,
                    dynfrontCMSpageID
                ]);
            }
            else {
                await this.connection.query(`update front_cms_pages SET 
                page_type=?,
                title=?,
                url=?,
                slug=?,
                meta_title=?,
                meta_description=?,
                meta_keyword=?,
                feature_image=?,
                description=?,
                sidebar=?
                where id=?`, [createFrontCmsPage.page_type,
                    createFrontCmsPage.title,
                    createFrontCmsPage.url,
                    createFrontCmsPage.slug,
                    createFrontCmsPage.meta_title,
                    createFrontCmsPage.meta_description,
                    createFrontCmsPage.meta_keyword,
                    createFrontCmsPage.feature_image,
                    createFrontCmsPage.description,
                    createFrontCmsPage.sidebar,
                    id
                ]);
                await this.connection.query(`update front_cms_page_contents SET 
                        content_type=?
                        where page_id=?`, [createFrontCmsPage.page_type,
                    id
                ]);
                const dynfrontCMSpage = await this.dynamicConnection.query('SELECT id FROM front_cms_pages WHERE hos_front_cms_pages_id=? and hospital_id=?', [id, createFrontCmsPage.hospital_id]);
                const dynfrontCMSpageID = dynfrontCMSpage[0].id;
                await this.dynamicConnection.query(`update front_cms_pages SET 
                page_type=?,
                title=?,
                url=?,
                slug=?,
                meta_title=?,
                meta_description=?,
                meta_keyword=?,
                feature_image=?,
                description=?,
                sidebar=?,
                hospital_id=?
                where id=?`, [createFrontCmsPage.page_type,
                    createFrontCmsPage.title,
                    createFrontCmsPage.url,
                    createFrontCmsPage.slug,
                    createFrontCmsPage.meta_title,
                    createFrontCmsPage.meta_description,
                    createFrontCmsPage.meta_keyword,
                    createFrontCmsPage.feature_image,
                    createFrontCmsPage.description,
                    createFrontCmsPage.sidebar,
                    createFrontCmsPage.hospital_id,
                    dynfrontCMSpageID
                ]);
                await this.dynamicConnection.query(`update front_cms_page_contents SET 
                        content_type=?,
                        hospital_id=?
                        where page_id=?`, [createFrontCmsPage.page_type,
                    createFrontCmsPage.hospital_id,
                    dynfrontCMSpageID
                ]);
            }
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS details updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM front_cms_pages WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
};
exports.FrontCmsPageService = FrontCmsPageService;
exports.FrontCmsPageService = FrontCmsPageService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], FrontCmsPageService);
//# sourceMappingURL=front_cms_page.service.js.map