"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontCmsMenuController = void 0;
const common_1 = require("@nestjs/common");
const front_cms_menu_service_1 = require("./front_cms_menu.service");
const front_cms_menu_entity_1 = require("./entities/front_cms_menu.entity");
let FrontCmsMenuController = class FrontCmsMenuController {
    constructor(frontCmsMenuService) {
        this.frontCmsMenuService = frontCmsMenuService;
    }
    create(createFrontCmsMenu) {
        return this.frontCmsMenuService.create(createFrontCmsMenu);
    }
    async removeFrontCMSMenu(id, hospital_id) {
        const deleteCMSMenu = await this.frontCmsMenuService.removeFrontCMSMenu(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    createMenuItems(createFrontCmsMenu) {
        return this.frontCmsMenuService.createMenuItems(createFrontCmsMenu);
    }
    updateFrontCMSMenuItems(id, createFrontCmsMenu) {
        return this.frontCmsMenuService.updateFrontCMSMenuItems(id, createFrontCmsMenu);
    }
    async removeFrontCMSMenuItems(id, hospital_id) {
        const deleteCMSMenuItems = await this.frontCmsMenuService.removeFrontCMSMenuItems(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.FrontCmsMenuController = FrontCmsMenuController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [front_cms_menu_entity_1.FrontCmsMenu]),
    __metadata("design:returntype", void 0)
], FrontCmsMenuController.prototype, "create", null);
__decorate([
    (0, common_1.Delete)('/removeMenu/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], FrontCmsMenuController.prototype, "removeFrontCMSMenu", null);
__decorate([
    (0, common_1.Post)('/addMenuItems'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [front_cms_menu_entity_1.FrontCmsMenu]),
    __metadata("design:returntype", void 0)
], FrontCmsMenuController.prototype, "createMenuItems", null);
__decorate([
    (0, common_1.Patch)('/updateMenuItems/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, front_cms_menu_entity_1.FrontCmsMenu]),
    __metadata("design:returntype", void 0)
], FrontCmsMenuController.prototype, "updateFrontCMSMenuItems", null);
__decorate([
    (0, common_1.Delete)('/removeMenuItems/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], FrontCmsMenuController.prototype, "removeFrontCMSMenuItems", null);
exports.FrontCmsMenuController = FrontCmsMenuController = __decorate([
    (0, common_1.Controller)('front-cms-menu'),
    __metadata("design:paramtypes", [front_cms_menu_service_1.FrontCmsMenuService])
], FrontCmsMenuController);
//# sourceMappingURL=front_cms_menu.controller.js.map