"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontCmsEventGalleryNewsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let FrontCmsEventGalleryNewsService = class FrontCmsEventGalleryNewsService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createFrontCmsEventGalleryNew) {
        try {
            const eventDate = new Date();
            let cms_event_id;
            const cmsEvent = await this.connection.query(`INSERT into front_cms_programs (
type,
slug,
url,
title,
date,
event_start,
event_end,
event_venue,
description,
is_active, 
meta_title,
meta_description,
meta_keyword,
feature_image,
publish,
sidebar
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, ['events',
                createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.event_start,
                createFrontCmsEventGalleryNew.event_end,
                createFrontCmsEventGalleryNew.event_venue,
                createFrontCmsEventGalleryNew.description,
                'no',
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                0,
                createFrontCmsEventGalleryNew.sidebar
            ]);
            cms_event_id = cmsEvent.insertId;
            await this.dynamicConnection.query(`INSERT into front_cms_programs (
type,
slug,
url,
title,
date,
event_start,
event_end,
event_venue,
description,
is_active, 
meta_title,
meta_description,
meta_keyword,
feature_image,
publish,
sidebar,
hospital_id,
hos_front_cms_programs_id
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, ['events',
                createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.event_start,
                createFrontCmsEventGalleryNew.event_end,
                createFrontCmsEventGalleryNew.event_venue,
                createFrontCmsEventGalleryNew.description,
                'no',
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                0,
                createFrontCmsEventGalleryNew.sidebar,
                createFrontCmsEventGalleryNew.hospital_id,
                cms_event_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS event details added successfully ",
                        "Event_values": await this.connection.query('SELECT * FROM front_cms_programs where id = ?', [cms_event_id])
                    }
                }];
        }
        catch (error) {
            console.error('Error inserting data:', error);
        }
    }
    async createNews(createFrontCmsEventGalleryNew) {
        try {
            const eventDate = new Date();
            let cms_news_id;
            const cmsNews = await this.connection.query(`INSERT into front_cms_programs (
type,
slug,
url,
title,
date,
description,
is_active, 
meta_title,
meta_description,
meta_keyword,
feature_image,
publish,
sidebar
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)`, ['notice',
                createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.description,
                'no',
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                0,
                createFrontCmsEventGalleryNew.sidebar
            ]);
            cms_news_id = cmsNews.insertId;
            await this.dynamicConnection.query(`INSERT into front_cms_programs (
type,
slug,
url,
title,
date,
description,
is_active, 
meta_title,
meta_description,
meta_keyword,
feature_image,
publish,
sidebar,
hospital_id,
hos_front_cms_programs_id
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, ['notice',
                createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.description,
                'no',
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                0,
                createFrontCmsEventGalleryNew.sidebar,
                createFrontCmsEventGalleryNew.hospital_id,
                cms_news_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS news details added successfully ",
                        "News_values": await this.connection.query('SELECT * FROM front_cms_programs where id = ?', [cms_news_id])
                    }
                }];
        }
        catch (error) {
            console.error('Error inserting data:', error);
        }
    }
    async createGallery(createFrontCmsEventGalleryNew) {
        try {
            const eventDate = new Date();
            let cms_program_id;
            const cmsPrograms = await this.connection.query(`INSERT into front_cms_programs (
type,
slug,
url,
title,
date,
description,
is_active, 
meta_title,
meta_description,
meta_keyword,
feature_image,
publish,
sidebar
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)`, ['gallery',
                createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.description,
                'no',
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                0,
                createFrontCmsEventGalleryNew.sidebar
            ]);
            cms_program_id = cmsPrograms.insertId;
            let cms_program_photos_id;
            const cmsProgramPhotos = await this.connection.query(`INSERT into front_cms_program_photos (
     program_id,
     media_gallery_id
              ) VALUES (?,?)`, [cms_program_id,
                createFrontCmsEventGalleryNew.media_gallery_id
            ]);
            cms_program_photos_id = cmsProgramPhotos.insertId;
            await this.dynamicConnection.query(`INSERT into front_cms_programs (
type,
slug,
url,
title,
date,
description,
is_active, 
meta_title,
meta_description,
meta_keyword,
feature_image,
publish,
sidebar,
hospital_id,
hos_front_cms_programs_id
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, ['gallery',
                createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.description,
                'no',
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                0,
                createFrontCmsEventGalleryNew.sidebar,
                createFrontCmsEventGalleryNew.hospital_id,
                cms_program_id
            ]);
            const [GetDyncmsmediagalleryid] = await this.dynamicConnection.query('SELECT id FROM front_cms_media_gallery WHERE hos_front_cms_media_gallery_id=? and hospital_id=?', [createFrontCmsEventGalleryNew.media_gallery_id, createFrontCmsEventGalleryNew.hospital_id]);
            const Get_Dyn_front_cms_media_gallery_ID = GetDyncmsmediagalleryid.id;
            await this.dynamicConnection.query(`INSERT into front_cms_program_photos (
     program_id,
     media_gallery_id,
     hospital_id,
     hos_front_cms_program_photos_id
              ) VALUES (?,?,?,?)`, [cms_program_id,
                Get_Dyn_front_cms_media_gallery_ID,
                createFrontCmsEventGalleryNew.hospital_id,
                cms_program_photos_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS gallery details added successfully ",
                        "gallery_values": await this.connection.query('SELECT * FROM front_cms_programs where id = ?', [cms_program_id])
                    }
                }];
        }
        catch (error) {
            console.error('Error inserting data:', error);
        }
    }
    async removeFrontCMSEvent(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM front_cms_programs WHERE id = ?', [id]);
            const [GetDyncmsprogramsid] = await this.dynamicConnection.query('SELECT id FROM front_cms_programs WHERE hos_front_cms_programs_id=? and hospital_id=?', [id, hospital_id]);
            const Get_Dyn_front_cms_programs_ID = GetDyncmsprogramsid.id;
            await this.dynamicConnection.query('DELETE FROM front_cms_programs WHERE id = ?', [Get_Dyn_front_cms_programs_ID]);
            return [
                {
                    status: 'success',
                    message: `Front CMS event with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async removeFrontCMSNews(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM front_cms_programs WHERE id = ?', [id]);
            const [GetDyncmsprogramsid] = await this.dynamicConnection.query('SELECT id FROM front_cms_programs WHERE hos_front_cms_programs_id=? and hospital_id=?', [id, hospital_id]);
            const Get_Dyn_front_cms_programs_ID = GetDyncmsprogramsid.id;
            await this.dynamicConnection.query('DELETE FROM front_cms_programs WHERE id = ?', [Get_Dyn_front_cms_programs_ID]);
            return [
                {
                    status: 'success',
                    message: `Front CMS news with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async removeFrontCMSGallery(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM front_cms_programs WHERE id = ?', [id]);
            await this.connection.query('DELETE FROM front_cms_program_photos WHERE program_id = ?', [id]);
            const [GetDyncmsprogramsid] = await this.dynamicConnection.query('SELECT id FROM front_cms_programs WHERE hos_front_cms_programs_id=? and hospital_id=?', [id, hospital_id]);
            const Get_Dyn_front_cms_programs_ID = GetDyncmsprogramsid.id;
            await this.dynamicConnection.query('DELETE FROM front_cms_programs WHERE id = ?', [Get_Dyn_front_cms_programs_ID]);
            await this.dynamicConnection.query('DELETE FROM front_cms_program_photos WHERE program_id = ?', [Get_Dyn_front_cms_programs_ID]);
            return [
                {
                    status: 'success',
                    message: `Front CMS gallery with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async updateFrontCMSevent(id, createFrontCmsEventGalleryNew) {
        try {
            const eventDate = new Date();
            await this.connection.query(`update front_cms_programs SET 
          slug=?,
          url=?,
          title=?,
          date=?,
          event_start=?,
          event_end=?,
          event_venue=?,
          description=?,
          meta_title=?,
          meta_description=?,
          meta_keyword=?,
          feature_image=?,
          sidebar=?
          where id=?`, [createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.event_start,
                createFrontCmsEventGalleryNew.event_end,
                createFrontCmsEventGalleryNew.event_venue,
                createFrontCmsEventGalleryNew.description,
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                createFrontCmsEventGalleryNew.sidebar,
                id
            ]);
            const dynfrontCMSprograms = await this.dynamicConnection.query('SELECT id FROM front_cms_programs WHERE hos_front_cms_programs_id=? and hospital_id=?', [id, createFrontCmsEventGalleryNew.hospital_id]);
            const dynfrontCMSprogramsID = dynfrontCMSprograms[0].id;
            await this.dynamicConnection.query(`update front_cms_programs SET 
          slug=?,
          url=?,
          title=?,
          date=?,
          event_start=?,
          event_end=?,
          event_venue=?,
          description=?,
          meta_title=?,
          meta_description=?,
          meta_keyword=?,
          feature_image=?,
          sidebar=?,
          hospital_id=?
          where id=?`, [createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.event_start,
                createFrontCmsEventGalleryNew.event_end,
                createFrontCmsEventGalleryNew.event_venue,
                createFrontCmsEventGalleryNew.description,
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                createFrontCmsEventGalleryNew.sidebar,
                createFrontCmsEventGalleryNew.hospital_id,
                dynfrontCMSprogramsID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS event updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM front_cms_programs WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async updateFrontCMSNews(id, createFrontCmsEventGalleryNew) {
        try {
            const eventDate = new Date();
            await this.connection.query(`update front_cms_programs SET 
          slug=?,
          url=?,
          title=?,
          date=?,
          description=?,
          meta_title=?,
          meta_description=?,
          meta_keyword=?,
          feature_image=?,
          sidebar=?
          where id=?`, [createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.description,
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                createFrontCmsEventGalleryNew.sidebar,
                id
            ]);
            const dynfrontCMSprograms = await this.dynamicConnection.query('SELECT id FROM front_cms_programs WHERE hos_front_cms_programs_id=? and hospital_id=?', [id, createFrontCmsEventGalleryNew.hospital_id]);
            const dynfrontCMSprogramsID = dynfrontCMSprograms[0].id;
            await this.dynamicConnection.query(`update front_cms_programs SET 
          slug=?,
          url=?,
          title=?,
          date=?,
          description=?,
          meta_title=?,
          meta_description=?,
          meta_keyword=?,
          feature_image=?,
          sidebar=?,
          hospital_id=?
          where id=?`, [createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.description,
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                createFrontCmsEventGalleryNew.sidebar,
                createFrontCmsEventGalleryNew.hospital_id,
                dynfrontCMSprogramsID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS news updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM front_cms_programs WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async updateFrontCMSGallery(id, createFrontCmsEventGalleryNew) {
        try {
            const eventDate = new Date();
            await this.connection.query(`update front_cms_programs SET 
          slug=?,
          url=?,
          title=?,
          date=?,
          description=?,
          meta_title=?,
          meta_description=?,
          meta_keyword=?,
          feature_image=?,
          sidebar=?
          where id=?`, [createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.description,
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                createFrontCmsEventGalleryNew.sidebar,
                id
            ]);
            await this.connection.query(`update front_cms_program_photos SET 
                  media_gallery_id=?
                  where program_id=?`, [createFrontCmsEventGalleryNew.media_gallery_id,
                id
            ]);
            const dynfrontCMSprograms = await this.dynamicConnection.query('SELECT id FROM front_cms_programs WHERE hos_front_cms_programs_id=? and hospital_id=?', [id, createFrontCmsEventGalleryNew.hospital_id]);
            const dynfrontCMSprogramsID = dynfrontCMSprograms[0].id;
            await this.dynamicConnection.query(`update front_cms_programs SET 
          slug=?,
          url=?,
          title=?,
          date=?,
          description=?,
          meta_title=?,
          meta_description=?,
          meta_keyword=?,
          feature_image=?,
          sidebar=?,
          hospital_id=?
          where id=?`, [createFrontCmsEventGalleryNew.slug,
                createFrontCmsEventGalleryNew.url,
                createFrontCmsEventGalleryNew.title,
                eventDate,
                createFrontCmsEventGalleryNew.description,
                createFrontCmsEventGalleryNew.meta_title,
                createFrontCmsEventGalleryNew.meta_description,
                createFrontCmsEventGalleryNew.meta_keyword,
                createFrontCmsEventGalleryNew.feature_image,
                createFrontCmsEventGalleryNew.sidebar,
                createFrontCmsEventGalleryNew.hospital_id,
                dynfrontCMSprogramsID
            ]);
            const [GetDyncmsmediagalleryid] = await this.dynamicConnection.query('SELECT id FROM front_cms_media_gallery WHERE hos_front_cms_media_gallery_id=? and hospital_id=?', [createFrontCmsEventGalleryNew.media_gallery_id, createFrontCmsEventGalleryNew.hospital_id]);
            const Get_Dyn_front_cms_media_gallery_ID = GetDyncmsmediagalleryid.id;
            await this.dynamicConnection.query(`update front_cms_program_photos SET 
                  media_gallery_id=?,
                  hospital_id=?
                  where program_id=?`, [Get_Dyn_front_cms_media_gallery_ID,
                createFrontCmsEventGalleryNew.hospital_id,
                dynfrontCMSprogramsID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS gallery updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM front_cms_programs WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
};
exports.FrontCmsEventGalleryNewsService = FrontCmsEventGalleryNewsService;
exports.FrontCmsEventGalleryNewsService = FrontCmsEventGalleryNewsService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], FrontCmsEventGalleryNewsService);
//# sourceMappingURL=front_cms_event_gallery_news.service.js.map