"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontCmsBannerService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let FrontCmsBannerService = class FrontCmsBannerService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createFrontCmsBanner) {
        try {
            let cms_program_id;
            const cmsPrograms = await this.connection.query(`INSERT into front_cms_programs (
type,
title,
is_active,
publish,
sidebar
         ) VALUES (?,?,?,?,?)`, ['banner',
                'Banner Images',
                'no',
                0,
                0
            ]);
            cms_program_id = cmsPrograms.insertId;
            let cms_program_photos_id;
            const cmsProgramPhotos = await this.connection.query(`INSERT into front_cms_program_photos (
     program_id,
     media_gallery_id
              ) VALUES (?,?)`, [cms_program_id,
                createFrontCmsBanner.media_gallery_id
            ]);
            cms_program_photos_id = cmsProgramPhotos.insertId;
            let Dyn_CMS_program_id;
            const Dyn_CMS_programs = await this.dynamicConnection.query(`INSERT into front_cms_programs (
type,
title,
is_active,
publish,
sidebar,
hospital_id,
hos_front_cms_programs_id
         ) VALUES (?,?,?,?,?,?,?)`, ['banner',
                'Banner Images',
                'no',
                0,
                0,
                createFrontCmsBanner.hospital_id,
                cms_program_id
            ]);
            Dyn_CMS_program_id = Dyn_CMS_programs.insertId;
            const [GetDyncmsmediagalleryid] = await this.dynamicConnection.query('SELECT id FROM front_cms_media_gallery WHERE hos_front_cms_media_gallery_id=? and hospital_id=?', [createFrontCmsBanner.media_gallery_id, createFrontCmsBanner.hospital_id]);
            const Get_Dyn_front_cms_media_gallery_ID = GetDyncmsmediagalleryid.id;
            await this.dynamicConnection.query(`INSERT into front_cms_program_photos (
     program_id,
     media_gallery_id,
     hospital_id,
     hos_front_cms_program_photos_id
              ) VALUES (?,?,?,?)`, [Dyn_CMS_program_id,
                Get_Dyn_front_cms_media_gallery_ID,
                createFrontCmsBanner.hospital_id,
                cms_program_photos_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS banner details added successfully ",
                        "banner_values": await this.connection.query('SELECT * FROM front_cms_programs where id = ?', [cms_program_id])
                    }
                }];
        }
        catch (error) {
            console.error('Error inserting data:', error);
        }
    }
    async removeFrontCMSBanner(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM front_cms_program_photos WHERE id = ?', [id]);
            await this.dynamicConnection.query('DELETE FROM front_cms_program_photos WHERE hospital_id = ? and hos_front_cms_program_photos_id=?', [hospital_id, id]);
            return [
                {
                    status: 'success',
                    message: `Front CMS banner with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async createbanner(createFrontCmsBanner) {
        try {
            let cms_program_photos_id;
            const cmsProgramPhotos = await this.connection.query(`INSERT into front_cms_program_photos (
       program_id,
       media_gallery_id
                ) VALUES (?,?)`, [createFrontCmsBanner.program_id,
                createFrontCmsBanner.media_gallery_id
            ]);
            cms_program_photos_id = cmsProgramPhotos.insertId;
            const [GetDyncmsmediagalleryid] = await this.dynamicConnection.query('SELECT id FROM front_cms_media_gallery WHERE hos_front_cms_media_gallery_id=? and hospital_id=?', [createFrontCmsBanner.media_gallery_id, createFrontCmsBanner.hospital_id]);
            const Get_Dyn_front_cms_media_gallery_ID = GetDyncmsmediagalleryid.id;
            const [GetDyncmsprogramid] = await this.dynamicConnection.query('SELECT id FROM front_cms_programs WHERE hos_front_cms_programs_id=? and hospital_id=?', [createFrontCmsBanner.program_id, createFrontCmsBanner.hospital_id]);
            const Get_Dyn_front_cms_program_ID = GetDyncmsprogramid.id;
            await this.dynamicConnection.query(`INSERT into front_cms_program_photos (
       program_id,
       media_gallery_id,
       hospital_id,
       hos_front_cms_program_photos_id
                ) VALUES (?,?,?,?)`, [Get_Dyn_front_cms_program_ID,
                Get_Dyn_front_cms_media_gallery_ID,
                createFrontCmsBanner.hospital_id,
                cms_program_photos_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Front CMS banner details added successfully ",
                        "banner_values": await this.connection.query('SELECT * FROM front_cms_program_photos where id = ?', [cms_program_photos_id])
                    }
                }];
        }
        catch (error) {
            console.error('Error inserting data:', error);
        }
    }
};
exports.FrontCmsBannerService = FrontCmsBannerService;
exports.FrontCmsBannerService = FrontCmsBannerService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], FrontCmsBannerService);
//# sourceMappingURL=front_cms_banner.service.js.map