"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindingsCategoryController = void 0;
const common_1 = require("@nestjs/common");
const findings_category_service_1 = require("./findings_category.service");
const findings_category_entity_1 = require("./entities/findings_category.entity");
const swagger_1 = require("@nestjs/swagger");
const auth_guard_1 = require("../auth/auth.guard");
let FindingsCategoryController = class FindingsCategoryController {
    constructor(findingsCategoryService) {
        this.findingsCategoryService = findingsCategoryService;
    }
    create(finding_category) {
        return this.findingsCategoryService.create(finding_category);
    }
    findAll() {
        return this.findingsCategoryService.findAll();
    }
    findOne(id) {
        return this.findingsCategoryService.findOne(id);
    }
    update(id, finding_category) {
        return this.findingsCategoryService.update(id, finding_category);
    }
    async remove(id, Hospital_id) {
        return this.findingsCategoryService.remove(id, Hospital_id);
    }
    SetupFindingCategory(search) {
        return this.findingsCategoryService.SetupFindingCategory(search);
    }
    async findAllDesig(limit, page, search) {
        try {
            let final_output = await this.findingsCategoryService.find_finding_category(limit || 10, page || 1, search || '');
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalpages: Math.ceil(final_output.total / final_output.limit),
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE
            };
        }
    }
};
exports.FindingsCategoryController = FindingsCategoryController;
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'insert findings_category options' }),
    (0, swagger_1.ApiBody)({ type: findings_category_entity_1.findingaa, description: 'data required.', }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'successfully.',
        type: [findings_category_entity_1.FindingsCategory]
    }),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [findings_category_entity_1.FindingsCategory]),
    __metadata("design:returntype", void 0)
], FindingsCategoryController.prototype, "create", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Get all findings_category options' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'List of genders returned successfully.', type: [findings_category_entity_1.FindingsCategory] }),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], FindingsCategoryController.prototype, "findAll", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Get one findings_category by id' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'List of genders returned successfully.', type: [findings_category_entity_1.FindingsCategory] }),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], FindingsCategoryController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, findings_category_entity_1.FindingsCategory]),
    __metadata("design:returntype", void 0)
], FindingsCategoryController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], FindingsCategoryController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/SetupfindingCategory/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], FindingsCategoryController.prototype, "SetupFindingCategory", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getallfinding_category'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], FindingsCategoryController.prototype, "findAllDesig", null);
exports.FindingsCategoryController = FindingsCategoryController = __decorate([
    (0, swagger_1.ApiTags)('FindingsCategory'),
    (0, common_1.Controller)('findings_category'),
    __metadata("design:paramtypes", [findings_category_service_1.FindingsCategoryService])
], FindingsCategoryController);
//# sourceMappingURL=findings_category.controller.js.map