"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FinanceIncomeService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let FinanceIncomeService = class FinanceIncomeService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(Entity) {
        try {
            const income = await this.connection.query(`Insert into income(inc_head_id,name,invoice_no,date,amount,note,is_deleted,documents,generated_by,is_active) values(?,?,?,?,?,?,?,?,?,?)`, [
                Entity.inc_head_id,
                Entity.name,
                Entity.invoice_no,
                Entity.date,
                Entity.amount,
                Entity.note,
                Entity.is_deleted,
                Entity.documents,
                Entity.generated_by,
                Entity.is_active,
            ]);
            const [inc_head_id] = await this.dynamicConnection.query(`select id from income_head where Hospital_id = ? and hospital_income_head_id = ?`, [Entity.hospital_id, Entity.inc_head_id]);
            await this.dynamicConnection.query(`insert into income(inc_head_id,name,invoice_no,date,amount,note,is_deleted,documents,generated_by,is_active,hospital_id,hos_income_id) 
  values (?,?,?,?,?,?,?,?,?,?,?,?)`, [
                inc_head_id.id,
                Entity.name,
                Entity.invoice_no,
                Entity.date,
                Entity.amount,
                Entity.note,
                Entity.is_deleted,
                Entity.documents,
                Entity.generated_by,
                Entity.is_active,
                Entity.hospital_id,
                income.insertId,
            ]);
            return [
                {
                    data: {
                        id: income.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        message: process.env.FINANCE_INCOME,
                        inserted_data: await this.connection.query(`select income.name as Name,income.invoice_no as invoice_number, income.date as Date,income.note as Description,income.documents as documents,
income_head.income_category as income_head,income.amount as Amount from income
left join income_head ON income.inc_head_id = income_head.id where income.id = ?`, [income.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                status: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                error: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findall() {
        try {
            const getincomes = await this.connection
                .query(`select income.id,income.name as Name,income.invoice_no as invoice_number, income.date as Date,income.note as Description,income.documents as documents,
    income_head.income_category as Income_Head,income.amount as Amount from income
    left join income_head ON income.inc_head_id = income_head.id`);
            return getincomes;
        }
        catch (error) {
            throw new common_1.HttpException({
                status: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                error: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findone(id) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM income WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.ERROR,
                message: process.env.EXISTING_RECORD
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const getincome = await this.connection.query(`select income.id,income.name as Name,income.invoice_no as invoice_number, income.date as Date,income.note as Description,income.documents as documents,
        income_head.income_category as income_head,income.amount as Amount from income
        left join income_head ON income.inc_head_id = income_head.id where income.id = ?`, [id]);
            return getincome;
        }
        catch (error) {
            throw new common_1.HttpException({
                status: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                error: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, Entity) {
        try {
            await this.connection.query(`
      update income SET inc_head_id = ?, name = ?, invoice_no = ?, date = ?, amount = ?, note = ?, documents = ? where income.id = ?`, [
                Entity.inc_head_id,
                Entity.name,
                Entity.invoice_no,
                Entity.date,
                Entity.amount,
                Entity.note,
                Entity.documents,
                id,
            ]);
            const [inc_head_id] = await this.dynamicConnection.query(`select id from income_head where Hospital_id = ? and hospital_income_head_id = ?`, [Entity.hospital_id, Entity.inc_head_id]);
            await this.dynamicConnection.query(`update income SET inc_head_id = ?, name = ?, invoice_no = ?, date = ?, amount = ?, note = ?, documents = ? where hos_income_id = ? and hospital_id = ?`, [
                inc_head_id.id,
                Entity.name,
                Entity.invoice_no,
                Entity.date,
                Entity.amount,
                Entity.note,
                Entity.documents,
                id,
                Entity.hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.FINANCE_INCOME_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM income WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                status: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                error: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Entity) {
        const [existingRecord] = await this.connection.query(`
      SELECT id FROM income WHERE id = ?`, [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.ERROR,
                message: process.env.EXISTING_RECORD
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            await this.connection.query(`Delete  from income where id = ?`, [id]);
            await this.dynamicConnection.query(`Delete  from income where hospital_id = ? and hos_income_id = ? `, [Entity.hospital_id, id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async finance_income(limit, page, search) {
        try {
            const offset = limit * (page - 1);
            let dateCondition = '';
            let searchClause = '';
            if (search) {
                searchClause = `(
      income.id LIKE '%${search}%' OR
      income.name LIKE '%${search}%' OR
      income.invoice_no LIKE '%${search}%' OR
      income.date LIKE '%${search}%' OR
      income.note LIKE '%${search}%' OR
      income_head.income_category LIKE '%${search}%' OR
      income.amount LIKE '%${search}%'
      )`;
                dateCondition = ` AND ${searchClause}`;
            }
            const finance_incomes = await this.connection.query(`select income.id,income.name as Name,income.invoice_no as invoice_number, income.date as Date,income.note as Description,
    income.documents as documents,
    income_head.income_category as Income_Head,income.amount as Amount from income
    left join income_head ON income.inc_head_id = income_head.id WHERE income.id  ${dateCondition} order by income.id desc LIMIT ? OFFSET ? `, [
                Number(limit), Number(offset)
            ]);
            let [totalist] = await this.connection.query(`SELECT count(income.id) as total FROM income 
      left join income_head ON income.inc_head_id = income_head.id WHERE income.id ${dateCondition}`);
            let variable = {
                details: finance_incomes,
                total: totalist.total,
                page: page,
                limit: limit
            };
            return variable;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.FinanceIncomeService = FinanceIncomeService;
exports.FinanceIncomeService = FinanceIncomeService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], FinanceIncomeService);
//# sourceMappingURL=finance_income.service.js.map