"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FaceAuthService = void 0;
const common_1 = require("@nestjs/common");
const client_s3_1 = require("@aws-sdk/client-s3");
const client_rekognition_1 = require("@aws-sdk/client-rekognition");
const path = require("path");
const aws_config_1 = require("../aws.config");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let FaceAuthService = class FaceAuthService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
        this.S3_BUCKET = 'ophub-face-auth-bucket';
        this.COLLECTION_ID = 'my-face-collection';
        this.s3 = new client_s3_1.S3Client({
            region: aws_config_1.awsConfig.region,
            credentials: {
                accessKeyId: aws_config_1.awsConfig.accessKeyId,
                secretAccessKey: aws_config_1.awsConfig.secretAccessKey,
            },
        });
        this.rekognition = new client_rekognition_1.RekognitionClient({
            region: aws_config_1.awsConfig.region,
            credentials: {
                accessKeyId: aws_config_1.awsConfig.accessKeyId,
                secretAccessKey: aws_config_1.awsConfig.secretAccessKey,
            },
        });
    }
    async uploadAndIndexFace(file) {
        const fileContent = file.buffer;
        const fileName = `${file.originalname}_${Date.now()}`;
        const s3Params = {
            Bucket: this.S3_BUCKET,
            Key: fileName,
            Body: fileContent,
            ContentType: file.mimetype,
        };
        await this.s3.send(new client_s3_1.PutObjectCommand(s3Params));
        const indexParams = {
            CollectionId: this.COLLECTION_ID,
            Image: {
                S3Object: {
                    Bucket: this.S3_BUCKET,
                    Name: fileName,
                },
            },
            ExternalImageId: path.parse(fileName).name,
            DetectionAttributes: [client_rekognition_1.Attribute.ALL],
        };
        const indexCommand = new client_rekognition_1.IndexFacesCommand(indexParams);
        const indexResult = await this.rekognition.send(indexCommand);
        const faces = indexResult.FaceRecords ?? [];
        if (faces.length > 1) {
            return {
                status: 'failed',
                message: 'Please provide a photo featuring only one individual and not a group photo.',
            };
        }
        else if (faces.length < 1) {
            return {
                status: 'failed',
                message: 'Invalid photo. Please upload a file with a human face.',
            };
        }
        const face = faces[0]?.FaceDetail;
        if (face?.Quality?.Brightness < 30) {
            return {
                status: 'failed',
                message: 'Invalid photo. Please upload a file with good brightness.',
            };
        }
        if (face?.Pose?.Yaw > 20 || face?.Pose?.Yaw < -35) {
            return {
                status: 'failed',
                message: 'Invalid photo. Please upload a photo with a straight face.',
            };
        }
        if (face?.Pose?.Pitch > 20 || face?.Pose?.Pitch < -20) {
            return {
                status: 'failed',
                message: 'Invalid photo. Please upload a photo with a straight face.',
            };
        }
        if (face?.Pose?.Roll > 10 || face?.Pose?.Roll < -20) {
            return {
                status: 'failed',
                message: 'Invalid photo. Please upload a photo with a straight face.',
            };
        }
        return {
            message: 'Face indexed successfully!',
            faceId: indexResult.FaceRecords[0].Face?.FaceId,
            key: fileName,
        };
    }
    async searchFace(file) {
        const fileContent = file.buffer;
        const fileName = path.basename(file.originalname);
        const s3Params = {
            Bucket: this.S3_BUCKET,
            Key: fileName,
            Body: fileContent,
            ContentType: file.mimetype,
        };
        await this.s3.send(new client_s3_1.PutObjectCommand(s3Params));
        const searchParams = {
            CollectionId: this.COLLECTION_ID,
            Image: {
                S3Object: {
                    Bucket: this.S3_BUCKET,
                    Name: fileName,
                },
            },
            FaceMatchThreshold: 90,
            MaxFaces: 1,
        };
        try {
            const searchCommand = new client_rekognition_1.SearchFacesByImageCommand(searchParams);
            const result = await this.rekognition.send(searchCommand);
            if (result.FaceMatches && result.FaceMatches.length > 0) {
                const getPatDetails = await this.dynamicConnection.query(`select * from patients where faceId = ?`, [result.FaceMatches[0].Face.FaceId]);
                return {
                    message: 'Face matched!',
                    patientDetails: getPatDetails,
                };
            }
            else {
                return { message: 'No matching face found.' };
            }
        }
        catch (error) {
            console.error(error);
            return { message: 'Face match failed', error };
        }
    }
    async getfaceID(key) {
        const searchParams = {
            CollectionId: this.COLLECTION_ID,
            Image: {
                S3Object: {
                    Bucket: this.S3_BUCKET,
                    Name: key,
                },
            },
            FaceMatchThreshold: 90,
            MaxFaces: 1,
        };
        try {
            const searchCommand = new client_rekognition_1.SearchFacesByImageCommand(searchParams);
            const result = await this.rekognition.send(searchCommand);
            if (result.FaceMatches.length > 0) {
                return {
                    faceID: result.FaceMatches[0].Face.FaceId,
                    message: 'Data fetched successfully',
                };
            }
            else {
                return {
                    message: 'No data found.',
                };
            }
        }
        catch (error) {
            console.error(error);
            return {
                message: 'Face match failed',
                error,
            };
        }
    }
};
exports.FaceAuthService = FaceAuthService;
exports.FaceAuthService = FaceAuthService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], FaceAuthService);
//# sourceMappingURL=face-auth.service.js.map