"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FaceController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const face_auth_service_1 = require("./face-auth.service");
const aws_config_1 = require("../aws.config");
const client_s3_1 = require("@aws-sdk/client-s3");
let FaceController = class FaceController {
    constructor(faceService) {
        this.faceService = faceService;
    }
    async uploadFace(file) {
        console.log(1213, file);
        if (!file) {
            throw new common_1.HttpException('No image uploaded', common_1.HttpStatus.BAD_REQUEST);
        }
        try {
            const result = await this.faceService.uploadAndIndexFace(file);
            return result;
        }
        catch (error) {
            console.log(error, "error");
            throw new common_1.HttpException(error.message, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async searchFace(file) {
        try {
            const result = await this.faceService.searchFace(file);
            return result;
        }
        catch (error) {
            throw new common_1.HttpException(error.message, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async FaceId(key) {
        try {
            const result = await this.faceService.getfaceID(key);
            return result;
        }
        catch (error) {
            throw new common_1.HttpException(error.message, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async getDocs(key) {
        try {
            const s3 = new client_s3_1.S3({
                credentials: {
                    accessKeyId: aws_config_1.awsConfig.accessKeyId,
                    secretAccessKey: aws_config_1.awsConfig.secretAccessKey,
                },
                region: aws_config_1.awsConfig.region,
            });
            const command = new client_s3_1.GetObjectCommand({
                Bucket: 'ophub-face-auth-bucket',
                Key: key,
            });
            const s3Data = await s3.send(command);
            const buffer = Buffer.from(await s3Data.Body.transformToByteArray());
            return buffer.toString('base64');
        }
        catch (error) {
            console.error(error);
            return error;
        }
    }
};
exports.FaceController = FaceController;
__decorate([
    (0, common_1.Post)('upload'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)("file")),
    __param(0, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], FaceController.prototype, "uploadFace", null);
__decorate([
    (0, common_1.Post)('search'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)("file")),
    __param(0, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], FaceController.prototype, "searchFace", null);
__decorate([
    (0, common_1.Post)('get-faceid'),
    __param(0, (0, common_1.Body)('key')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], FaceController.prototype, "FaceId", null);
__decorate([
    (0, common_1.Post)('getImage'),
    __param(0, (0, common_1.Body)('key')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], FaceController.prototype, "getDocs", null);
exports.FaceController = FaceController = __decorate([
    (0, common_1.Controller)('face'),
    __metadata("design:paramtypes", [face_auth_service_1.FaceAuthService])
], FaceController);
//# sourceMappingURL=face-auth.controller.js.map