"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrPatientDetailsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let EmrPatientDetailsService = class EmrPatientDetailsService {
    constructor(connection) {
        this.connection = connection;
    }
    async findall(patients_id, mobile_no) {
        const patient = await this.connection.query(`select patients.id,patients.patient_name, patients.mobileno, patients.dob, 
concat(patients.age, " " ,"years") as age, patients.gender from patients where patients.id = ? or patients.mobileno = ?`, [patients_id, mobile_no]);
        return patient;
    }
    async finddoctor(staff_id) {
        const doctor = await this.connection.query(`select staff.id, CONCAT("DR.",staff.name, ' ', staff.surname) AS staffname, charges.standard_charge,tax_category.percentage tax_percentage, round((charges.standard_charge+
        (charges.standard_charge*((tax_category.percentage)/100))),2)  as amount from shift_details
left join staff on shift_details.staff_id = staff.id
left join charges on shift_details.charge_id = charges.id 
join tax_category on charges.tax_category_id = tax_category.id
where staff.id = ?`, [staff_id]);
        return doctor;
    }
    async findDoctor_shift(staff_id) {
        const doctor_shift = await this.connection.query(` SELECT doctor_shift.id,doctor_shift.staff_id AS doctor,
                   doctor_shift.day AS date,
                   global_shift.name AS shift
            FROM doctor_shift
            LEFT JOIN global_shift ON doctor_shift.global_shift_id = global_shift.id
            WHERE doctor_shift.staff_id = ?`, [staff_id]);
        return doctor_shift;
    }
    async findDoctor_slot(staff_id, global_shift) {
        const doctor_time = await this.connection.query(`
      SELECT doctor_shift.id,doctor_shift.staff_id AS doctor,
               doctor_shift.day AS date,
               global_shift.name AS shift,
               CONCAT(doctor_shift.start_time, "-", doctor_shift.end_time) AS slot
        FROM doctor_shift
        LEFT JOIN global_shift ON doctor_shift.global_shift_id = global_shift.id
        WHERE doctor_shift.staff_id = ?

          AND doctor_shift.global_shift_id = ? `, [staff_id, global_shift]);
        return doctor_time;
    }
};
exports.EmrPatientDetailsService = EmrPatientDetailsService;
exports.EmrPatientDetailsService = EmrPatientDetailsService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], EmrPatientDetailsService);
//# sourceMappingURL=emr_patient_details.service.js.map