"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrOpdFilterService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let EmrOpdFilterService = class EmrOpdFilterService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll(fromDate, toDate, doctorId, gender, status) {
        try {
            let query = `  
 SELECT distinct
    visit_details.id AS id, 
    patients.patient_name AS name, 
    patients.id AS PT_id, 
    CONCAT(patients.age, ' years') AS age, 
    patients.gender, 
    patients.image,
    CONCAT('OPN', visit_details.opd_details_id) AS OP_NO, 
    patients.mobileno, 
    patients.dial_code, 
    CONCAT('Dr. ', staff.name, ' ', staff.surname) AS consultant,
    visit_details.cons_doctor AS doctor_id, 
   concat(doctor_shift.start_time,'-',doctor_shift.end_time) as time_slot,
    patients.abha_address, 
    patient_charges.amount AS apptFees,    
    visit_details.appointment_date,
                opd_status.status,
                appointment_queue.position

FROM 
    visit_details 
    left join opd_details ON visit_details.opd_details_id = opd_details.id
    left join patients ON opd_details.patient_id = patients.id
LEFT JOIN 
    patient_charges ON patient_charges.id = visit_details.patient_charge_id
LEFT JOIN 
    staff ON staff.id = visit_details.cons_doctor
LEFT JOIN 
   doctor_shift on  visit_details.cons_doctor = doctor_shift.staff_id
   and dayname(visit_details.appointment_date) = doctor_shift.day
   and time(visit_details.appointment_date) >= time(doctor_shift.start_time) 
   and time(visit_details.appointment_date) <= time(doctor_shift.end_time) 
    LEFT JOIN opd_status ON opd_status.opd_id = opd_details.id
        Left join appointment_queue on appointment_queue.opd_id = opd_details.id
 `;
            let date;
            let values = [];
            if (fromDate && toDate) {
                date = `date(visit_details.appointment_date) >= date( '` + fromDate + `' ) and date(visit_details.appointment_date) <= date( '` + toDate + `' )`;
            }
            else if (fromDate) {
                date = ` date(visit_details.appointment_date) >= date( '` + fromDate + `')`;
            }
            else if (toDate) {
                date = ` date(visit_details.appointment_date) <= date( '` + toDate + `')`;
            }
            else {
                date = `visit_details.appointment_date `;
            }
            let where = `WHERE  ` + date;
            if (doctorId) {
                where += ` and visit_details.cons_doctor = ?`;
                values.push(doctorId);
            }
            if (gender) {
                where += ` AND patients.gender = ?`;
                values.push(gender);
            }
            if (status) {
                where += ` AND opd_status.status = ?`;
                values.push(status);
            }
            let order = `ORDER BY date(visit_details.appointment_date) ASC  `;
            let final = query + where + order;
            const GetTodayOPD = await this.connection.query(final, values);
            return GetTodayOPD;
        }
        catch (error) {
            return error;
        }
    }
};
exports.EmrOpdFilterService = EmrOpdFilterService;
exports.EmrOpdFilterService = EmrOpdFilterService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], EmrOpdFilterService);
//# sourceMappingURL=emr_opd_filter.service.js.map