"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrAppointmentStatusService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let EmrAppointmentStatusService = class EmrAppointmentStatusService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async findAll(hospital_id) {
        if (hospital_id) {
            try {
                const getStatus = await this.connection.query(`select * from appointment_status`);
                return getStatus;
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                "status": "failed",
                "message": "Enter hospital_id to get appointment status"
            };
        }
    }
    async appointment_status_tracking(hospital_id, appointment_id) {
        if (hospital_id) {
            if (appointment_id) {
                try {
                    const query = `select appointment_status_id from appointment_status_tracking 
        WHERE appointment_id = ? order by appointment_status_tracking.appointment_status_id DESC limit 1`;
                    let numb;
                    try {
                        numb = appointment_id.replace(/[a-zA-Z]/g, '');
                    }
                    catch (err) {
                        numb = appointment_id;
                    }
                    let getAllStatus = await this.connection.query(`select * from appointment_status`);
                    const [appointmentStatusData] = await this.connection.query(query, [numb]);
                    let latestappt_status_id = appointmentStatusData.appointment_status_id;
                    if (latestappt_status_id != 4) {
                        getAllStatus = getAllStatus.filter(item => item.id !== 4);
                        getAllStatus.forEach(obj => {
                            obj.is_completed = obj.id <= latestappt_status_id ? 1 : 0;
                        });
                        return getAllStatus;
                    }
                    else {
                        getAllStatus = getAllStatus.filter(item => item.id <= 4);
                        let try1 = await this.connection.query(`select appointment_status_id from appointment_status_tracking 
    WHERE appointment_id = ?`, [numb]);
                        let try2 = await this.connection.query(`select distinct appointment_status_id from appointment_status_tracking 
      WHERE appointment_id = ? order by appointment_status_tracking.appointment_status_id DESC `, [numb]);
                        getAllStatus.forEach(async (item) => {
                            try1.forEach(a => {
                                if (item.id <= try2[try2.length - 2].appointment_status_id) {
                                    item.is_completed = 1;
                                }
                                else {
                                    item.is_completed = 0;
                                }
                                if (item.id == 4) {
                                    item.is_completed = 1;
                                }
                            });
                        });
                    }
                    const filteredArray = getAllStatus.filter(item => item.is_completed === 1);
                    return filteredArray;
                }
                catch (error) {
                    return error;
                }
            }
            else {
                return {
                    status: "failed",
                    message: "Enter appointment_id to get the values"
                };
            }
        }
        else {
            return {
                status: "failed",
                message: "Enter hospital_id to get the values"
            };
        }
    }
};
exports.EmrAppointmentStatusService = EmrAppointmentStatusService;
exports.EmrAppointmentStatusService = EmrAppointmentStatusService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], EmrAppointmentStatusService);
//# sourceMappingURL=emr_appointment_status.service.js.map