"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrAppointmentFilterService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let EmrAppointmentFilterService = class EmrAppointmentFilterService {
    constructor(connection) {
        this.connection = connection;
    }
    async find_slot_filter(global_shift_id, date, staff_id) {
        try {
            const filter = await this.connection.query(`select distinct doctor_shift.id as id, doctor_shift.global_shift_id, doctor_shift.start_time, doctor_shift.end_time from doctor_shift
where doctor_shift.global_shift_id = ?  and doctor_shift.day = dayname(?)`, [global_shift_id, date, staff_id]);
            return filter;
        }
        catch (error) {
            return error;
        }
    }
    async find_shift_filter(staff_id, date) {
        try {
            const shift_filter = await this.connection.query(`select distinct global_shift.id as id, doctor_global_shift.staff_id, global_shift.name ,doctor_shift.day,  global_shift.start_time, global_shift.end_time from global_shift 
 left join doctor_shift on doctor_shift.global_shift_id = global_shift.id 
left join doctor_global_shift on doctor_global_shift.global_shift_id = global_shift.id
where doctor_global_shift.staff_id = ? and doctor_shift.day = dayname(?)`, [staff_id, date]);
            return shift_filter;
        }
        catch (error) {
            return error;
        }
    }
};
exports.EmrAppointmentFilterService = EmrAppointmentFilterService;
exports.EmrAppointmentFilterService = EmrAppointmentFilterService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], EmrAppointmentFilterService);
//# sourceMappingURL=emr_appointment_filter.service.js.map