"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrAddNewPatientService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const uuid_1 = require("uuid");
const face_auth_service_1 = require("../face-auth/face-auth.service");
let EmrAddNewPatientService = class EmrAddNewPatientService {
    constructor(connection, dynamicConnection, addAppointmentService) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
        this.addAppointmentService = addAppointmentService;
    }
    async create(Entity) {
        if (Entity.is_confirmed_to_create_new_patient == true) {
            let uuid = (0, uuid_1.v4)();
            try {
                let faceID = null;
                if (Entity.image && Entity.image.trim() != '') {
                    const getFaceId = await this.addAppointmentService.getfaceID(Entity.image);
                    faceID = getFaceId?.faceID;
                }
                await this.dynamicConnection.query(`INSERT INTO patients ( lang_id,patient_name, dob, image,faceId,  mobileno, email, gender, marital_status,
blood_bank_product_id,
   address,guardian_name,ABHA_number, known_allergies, note,insurance_id, insurance_validity,abha_address,aayush_unique_id
   ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)`, [
                    Entity.lang_id,
                    Entity.patient_name,
                    Entity.dob,
                    Entity.image,
                    faceID,
                    Entity.mobileno,
                    Entity.email,
                    Entity.gender,
                    Entity.marital_status,
                    Entity.blood_bank_product_id,
                    Entity.address,
                    Entity.guardian_name,
                    Entity.ABHA_number,
                    Entity.known_allergies,
                    Entity.note,
                    Entity.insurance_id,
                    Entity.insurance_validity,
                    Entity.abha_address,
                    uuid
                ]);
                const result = await this.connection.query(`INSERT INTO patients ( lang_id,patient_name, dob, image,faceId,  mobileno, email, gender, marital_status,
    blood_bank_product_id,
       address,guardian_name,ABHA_number, known_allergies, note,insurance_id, insurance_validity,abha_address,aayush_unique_id
       ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)`, [
                    Entity.lang_id,
                    Entity.patient_name,
                    Entity.dob,
                    Entity.image,
                    faceID,
                    Entity.mobileno,
                    Entity.email,
                    Entity.gender,
                    Entity.marital_status,
                    Entity.blood_bank_product_id,
                    Entity.address,
                    Entity.guardian_name,
                    Entity.ABHA_number,
                    Entity.known_allergies,
                    Entity.note,
                    Entity.insurance_id,
                    Entity.insurance_validity,
                    Entity.abha_address,
                    uuid
                ]);
                const free = result.insertId;
                return [{
                        "data ": {
                            "id  ": free,
                            "status": "success",
                            "messege": "patients details added successfully ",
                            "inserted_data": await this.connection.query('SELECT * FROM patients WHERE id = ?', [free])
                        }
                    }];
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                "status": "failed",
                "message": "should verify for existing patient with mobile number"
            };
        }
    }
    async findall() {
        const find_patient = await this.connection.query(`select * from patients`);
        return find_patient;
    }
    async findone(id) {
        const find_patient_id = await this.connection.query(`select * from patients where id = ?`, [id]);
        return find_patient_id;
    }
    async update(id, Entity) {
        try {
            let faceID = null;
            if (Entity.image && Entity.image.trim() != '') {
                const getFaceId = await this.addAppointmentService.getfaceID(Entity.image);
                faceID = getFaceId?.faceID;
            }
            await this.connection.query(`update patients SET mobileno = ?,faceId = ?, ABHA_number = ?, patient_name = ?, guardian_name = ? ,
  gender = ?, dob = ?, age = ?, blood_bank_product_id = ?, emergency_mobile_no = ?, 
  email = ?, address = ?,insurance_id = ?, insurance_validity = ?, abha_address = ? where id = ?`, [
                Entity.mobileno,
                faceID,
                Entity.ABHA_number,
                Entity.patient_name,
                Entity.guardian_name,
                Entity.gender,
                Entity.dob,
                Entity.age,
                Entity.blood_bank_product_id,
                Entity.emergency_mobile_no,
                Entity.email,
                Entity.address,
                Entity.insurance_id,
                Entity.insurance_validity,
                Entity.abha_address,
                id
            ]);
            return [
                {
                    'data ': {
                        status: 'success',
                        messege: 'patients details updated successfully ',
                        updated_values: await this.connection.query('SELECT * FROM patients WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            return [
                {
                    status: 'failed',
                    messege: 'cannot update patients profile',
                    error: error,
                },
            ];
        }
    }
    async remove(id) {
        await this.connection.query(`DELETE from patients where id = ?`, [id]);
        return [
            {
                status: "success",
                message: ' id: ' + id + ' deleted successfully',
            }
        ];
    }
};
exports.EmrAddNewPatientService = EmrAddNewPatientService;
exports.EmrAddNewPatientService = EmrAddNewPatientService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __param(2, (0, common_1.Inject)((0, common_1.forwardRef)(() => face_auth_service_1.FaceAuthService))),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        face_auth_service_1.FaceAuthService])
], EmrAddNewPatientService);
//# sourceMappingURL=emr_add-new-patient.service.js.map