"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DonorDetailsController = void 0;
const common_1 = require("@nestjs/common");
const donor_details_service_1 = require("./donor_details.service");
const donor_detail_entity_1 = require("./entities/donor_detail.entity");
const auth_guard_1 = require("../auth/auth.guard");
let DonorDetailsController = class DonorDetailsController {
    constructor(donorDetailsService) {
        this.donorDetailsService = donorDetailsService;
    }
    create(createDonorDetail) {
        return this.donorDetailsService.create(createDonorDetail);
    }
    updateBloodDonorDetail(id, createDonorDetail) {
        return this.donorDetailsService.updateBloodDonorDetail(id, createDonorDetail);
    }
    createBloodDonorCycle(createDonorDetail) {
        return this.donorDetailsService.createBloodDonorCycle(createDonorDetail);
    }
    async removeBloodDonorCycle(id, hospital_id) {
        const deleteBloodDonorCycle = await this.donorDetailsService.removeBloodDonorCycle(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async removeDonorandDonorCycle(id, hospital_id) {
        const deleteDonorandDonorCycle = await this.donorDetailsService.removeDonorandDonorCycle(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    createComponents(createDonorDetail) {
        return this.donorDetailsService.createComponents(createDonorDetail);
    }
};
exports.DonorDetailsController = DonorDetailsController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [donor_detail_entity_1.DonorDetail]),
    __metadata("design:returntype", void 0)
], DonorDetailsController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, donor_detail_entity_1.DonorDetail]),
    __metadata("design:returntype", void 0)
], DonorDetailsController.prototype, "updateBloodDonorDetail", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/bloodDonorCycle/blood'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [donor_detail_entity_1.DonorDetail]),
    __metadata("design:returntype", void 0)
], DonorDetailsController.prototype, "createBloodDonorCycle", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], DonorDetailsController.prototype, "removeBloodDonorCycle", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/deleteDonorandDonorCycle/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], DonorDetailsController.prototype, "removeDonorandDonorCycle", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/components'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], DonorDetailsController.prototype, "createComponents", null);
exports.DonorDetailsController = DonorDetailsController = __decorate([
    (0, common_1.Controller)('donor-details'),
    __metadata("design:paramtypes", [donor_details_service_1.DonorDetailsService])
], DonorDetailsController);
//# sourceMappingURL=donor_details.controller.js.map