"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardIncomeExpenseService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let DashboardIncomeExpenseService = class DashboardIncomeExpenseService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    handleError(error) {
        throw new common_1.HttpException({
            statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
            message: process.env.ERROR_MESSAGE_V2,
        }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
    }
    formatAmount(value) {
        return parseFloat(value).toFixed(2);
    }
    async getDailyAppointmentIncome() {
        try {
            const result = await this.dynamicConnection.query(`
        SELECT COALESCE(SUM(amount), 0.00) AS dailyAppointmentIncome
FROM transactions
WHERE section = 'Appointment'
  AND payment_date >= CURDATE()
  AND payment_date < CURDATE() + INTERVAL 1 DAY
      `);
            return {
                dailyAppointmentIncome: this.formatAmount(result[0].dailyAppointmentIncome),
            };
        }
        catch (error) {
            this.handleError(error);
        }
    }
    async getDailyOpdIncome() {
        try {
            const result = await this.dynamicConnection.query(`
        SELECT COALESCE(SUM(amount), 0.00) AS dailyOpdIncome
FROM transactions
WHERE section = 'OPD'
  AND payment_date >= CURDATE()
  AND payment_date < CURDATE() + INTERVAL 1 DAY
      `);
            return {
                dailyOpdIncome: this.formatAmount(result[0].dailyOpdIncome),
            };
        }
        catch (error) {
            this.handleError(error);
        }
    }
    async getDailyIpdIncome() {
        try {
            const result = await this.dynamicConnection.query(`
        SELECT COALESCE(SUM(amount), 0.00) AS dailyIpdIncome
FROM transactions
WHERE section = 'IPD'
  AND payment_date >= CURDATE()
  AND payment_date < CURDATE() + INTERVAL 1 DAY
      `);
            return {
                dailyIpdIncome: this.formatAmount(result[0].dailyIpdIncome),
            };
        }
        catch (error) {
            this.handleError(error);
        }
    }
    async getTotalIncome() {
        try {
            const result = await this.dynamicConnection.query(`
        SELECT COALESCE(SUM(amount), 0.00) AS "totalIncome"
        FROM income
      `);
            return {
                totalIncome: this.formatAmount(result[0].totalIncome),
            };
        }
        catch (error) {
            this.handleError(error);
        }
    }
    async getTotalExpenses() {
        try {
            const result = await this.dynamicConnection.query(`
        SELECT COALESCE(SUM(amount), 0.00) AS "totalExpenses"
        FROM expenses
      `);
            return {
                totalExpenses: this.formatAmount(result[0].totalExpenses),
            };
        }
        catch (error) {
            this.handleError(error);
        }
    }
};
exports.DashboardIncomeExpenseService = DashboardIncomeExpenseService;
exports.DashboardIncomeExpenseService = DashboardIncomeExpenseService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], DashboardIncomeExpenseService);
//# sourceMappingURL=dashboard_income_expense.service.js.map