"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsultationProcessListService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const qr_encrpyt_service_1 = require("../qr-encrpyt/qr-encrpyt.service");
let ConsultationProcessListService = class ConsultationProcessListService {
    constructor(connection, dynamicConnection, EncryptedService) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
        this.EncryptedService = EncryptedService;
    }
    async create(Entity) {
        try {
            const insertInHos = await this.connection.query(`insert into PT_consultation_process_list (process_name,
  process_description,lattitude,longitude
) values(?,?,?,?)`, [
                Entity.process_name,
                Entity.process_description,
                Entity.lattitude,
                Entity.longitude,
            ]);
            await this.dynamicConnection.query(`insert into PT_consultation_process_list (process_name,
  process_description,
  hospital_id,
  hos_PT_consultation_process_list_id,lattitude,longitude
) values(?,?,?,?,?,?)`, [
                Entity.process_name,
                Entity.process_description,
                Entity.hospital_id,
                insertInHos.insertId,
                Entity.lattitude,
                Entity.longitude,
            ]);
            return {
                status: process.env.SUCCESS_STATUS_V2,
                message: process.env.CONSULTATION_PROCESS,
                inserted_details: await this.connection.query(`select * from PT_consultation_process_list where id = ?`, [insertInHos.insertId]),
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const getAll = await this.connection.query(`select * from PT_consultation_process_list`);
            return getAll;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id) {
        try {
            const getAll = await this.connection.query(`select * from PT_consultation_process_list where id = ?`, [id]);
            return getAll;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOneQR(id) {
        try {
            const [getAll] = await this.connection.query(`select * from PT_consultation_process_list where id = ?`, [id]);
            let resp = {
                QR_type_id: 2,
                QR_type: 'consultaionProcessQR',
                conslutation_process_details: getAll,
            };
            return resp;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async EncryptedfindOneQR(id, hospital_id) {
        try {
            const [getAll] = await this.connection.query(`select id, process_name, process_description from PT_consultation_process_list where id = ?`, [id]);
            getAll.QR_type_id = 2;
            getAll.QR_type = 'consultaionProcessQR';
            let resp = getAll;
            getAll.hospital_id = hospital_id;
            const encrypt_apicall = await this.EncryptedService.encrypt(JSON.stringify(resp), process.env.encryption_key, process.env.encryption_iv);
            getAll.hospital_id = hospital_id;
            return encrypt_apicall;
        }
        catch (error) {
            console.log(error, 'error');
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, Entity) {
        try {
            await this.connection.query(`update PT_consultation_process_list set process_name = ?,
  process_description = ?
where id = ?`, [Entity.process_name, Entity.process_description, id]);
            await this.dynamicConnection.query(`update  PT_consultation_process_list SET process_name = ?,
  process_description = ? where
  hospital_id = ? and
  hos_PT_consultation_process_list_id = ?`, [
                Entity.process_name,
                Entity.process_description,
                Entity.hospital_id,
                id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.CONSULTATION_PROCESS_UPDATED,
                        updated_values: await this.connection.query('SELECT * FROM PT_consultation_process_list WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, hospital_id) {
        await this.connection.query(`delete from PT_consultation_process_list where id = ?`, [id]);
        try {
            const deladmin = await this.dynamicConnection.query(`select id from PT_consultation_process_list where hos_PT_consultation_process_list_id = ? `, [id]);
            const deleteadmin = deladmin[0].id;
            await this.dynamicConnection.query(`delete from PT_consultation_process_list where id = ? and hospital_id = ?`, [deleteadmin, hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED,
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.ConsultationProcessListService = ConsultationProcessListService;
exports.ConsultationProcessListService = ConsultationProcessListService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __param(2, (0, common_1.Inject)((0, common_1.forwardRef)(() => qr_encrpyt_service_1.CryptoService))),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        qr_encrpyt_service_1.CryptoService])
], ConsultationProcessListService);
//# sourceMappingURL=consultation-process-list.service.js.map