"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsultationProcessListController = void 0;
const common_1 = require("@nestjs/common");
const consultation_process_list_service_1 = require("./consultation-process-list.service");
const consultation_process_list_entity_1 = require("./entities/consultation-process-list.entity");
const auth_guard_1 = require("../auth/auth.guard");
let ConsultationProcessListController = class ConsultationProcessListController {
    constructor(consultationProcessListService) {
        this.consultationProcessListService = consultationProcessListService;
    }
    create(Entity) {
        return this.consultationProcessListService.create(Entity);
    }
    findAll() {
        return this.consultationProcessListService.findAll();
    }
    findOne(id) {
        return this.consultationProcessListService.findOne(+id);
    }
    findOneQR(id) {
        return this.consultationProcessListService.findOneQR(+id);
    }
    update(id, Entity) {
        return this.consultationProcessListService.update(+id, Entity);
    }
    async remove(id, hospital_id) {
        const deletelist = await this.consultationProcessListService.remove(id, hospital_id);
        return {
            status: `success`,
            message: `id: ${id} deleted successfully`,
        };
    }
    EncryptfindOneQR(id, hospital_id) {
        return this.consultationProcessListService.EncryptedfindOneQR(+id, hospital_id);
    }
};
exports.ConsultationProcessListController = ConsultationProcessListController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [consultation_process_list_entity_1.ConsultationProcessList]),
    __metadata("design:returntype", void 0)
], ConsultationProcessListController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ConsultationProcessListController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ConsultationProcessListController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/QR/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], ConsultationProcessListController.prototype, "findOneQR", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, consultation_process_list_entity_1.ConsultationProcessList]),
    __metadata("design:returntype", void 0)
], ConsultationProcessListController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", Promise)
], ConsultationProcessListController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/Encrypt-QR/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)(`hospital_id`)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], ConsultationProcessListController.prototype, "EncryptfindOneQR", null);
exports.ConsultationProcessListController = ConsultationProcessListController = __decorate([
    (0, common_1.Controller)('consultation-process-list'),
    __metadata("design:paramtypes", [consultation_process_list_service_1.ConsultationProcessListService])
], ConsultationProcessListController);
//# sourceMappingURL=consultation-process-list.controller.js.map