"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentIssueController = void 0;
const common_1 = require("@nestjs/common");
const component_issue_service_1 = require("./component_issue.service");
const component_issue_entity_1 = require("./entities/component_issue.entity");
const auth_guard_1 = require("../auth/auth.guard");
let ComponentIssueController = class ComponentIssueController {
    constructor(componentIssueService) {
        this.componentIssueService = componentIssueService;
    }
    create(createComponentIssue) {
        return this.componentIssueService.create(createComponentIssue);
    }
    AddPayment(createComponentIssue) {
        return this.componentIssueService.AddPayment(createComponentIssue);
    }
    updateComponentIssue(id, createComponentIssue) {
        return this.componentIssueService.updateComponentIssue(id, createComponentIssue);
    }
    async deleteComponentIssuePayment(id, hospital_id) {
        const removeComponentIssuePayment = await this.componentIssueService.deleteComponentIssuePayment(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async removeComponentIssue(id, hospital_id) {
        const deleteComponentIssue = await this.componentIssueService.removeComponentIssue(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async removeonlycomponentissue(id, hospital_id) {
        const deleteOnlycomponentIssue = await this.componentIssueService.removeonlycomponentissue(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.ComponentIssueController = ComponentIssueController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [component_issue_entity_1.ComponentIssue]),
    __metadata("design:returntype", void 0)
], ComponentIssueController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/AddPayment'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [component_issue_entity_1.ComponentIssue]),
    __metadata("design:returntype", void 0)
], ComponentIssueController.prototype, "AddPayment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, component_issue_entity_1.ComponentIssue]),
    __metadata("design:returntype", void 0)
], ComponentIssueController.prototype, "updateComponentIssue", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/deleteComponentIssuePayment/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], ComponentIssueController.prototype, "deleteComponentIssuePayment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], ComponentIssueController.prototype, "removeComponentIssue", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/deleteonlycomponentissue/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], ComponentIssueController.prototype, "removeonlycomponentissue", null);
exports.ComponentIssueController = ComponentIssueController = __decorate([
    (0, common_1.Controller)('component-issue'),
    __metadata("design:paramtypes", [component_issue_service_1.ComponentIssueService])
], ComponentIssueController);
//# sourceMappingURL=component_issue.controller.js.map