"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckForDuplicateAppointmentService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let CheckForDuplicateAppointmentService = class CheckForDuplicateAppointmentService {
    constructor(connection) {
        this.connection = connection;
    }
    async create(AppointmentEntity) {
        try {
            const checkDuplicate = await this.connection.query(`select * from appointment 
      where patient_id = ? and doctor = ? and shift_id = ? and date = ? and appointment_status_id <> 4`, [
                AppointmentEntity.patient_id,
                AppointmentEntity.doctor,
                AppointmentEntity.shift_id,
                AppointmentEntity.date
            ]);
            if (checkDuplicate.length > 0) {
                return {
                    "status": process.env.SUCCESS_STATUS_V2,
                    "message": process.env.DUPLICATE_APPOINTMENT,
                    "is_duplicate_appointment": true
                };
            }
            else {
                return {
                    "status": process.env.SUCCESS_STATUS_V2,
                    "message": process.env.APPOINTMENT_BOOKED,
                    "is_duplicate_appointment": false
                };
            }
        }
        catch (error) {
            return {
                "status": process.env.ERROR_STATUS_V2,
                "message": process.env.ERROR_MESSAGE_V2,
                "error": error
            };
        }
    }
};
exports.CheckForDuplicateAppointmentService = CheckForDuplicateAppointmentService;
exports.CheckForDuplicateAppointmentService = CheckForDuplicateAppointmentService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], CheckForDuplicateAppointmentService);
//# sourceMappingURL=check-for-duplicate-appointment.service.js.map