"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificatesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let CertificatesService = class CertificatesService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createCertificate) {
        try {
            let certificates_id;
            const certificate = await this.connection.query(`INSERT into certificates (
certificate_name,
certificate_text,
left_header,
center_header,
right_header,
left_footer,
right_footer,
center_footer,
background_image,
created_for,
status,
header_height,
content_height,
footer_height,
content_width,
enable_patient_image,
enable_image_height
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createCertificate.certificate_name,
                createCertificate.certificate_text,
                createCertificate.left_header,
                createCertificate.center_header,
                createCertificate.right_header,
                createCertificate.left_footer,
                createCertificate.right_footer,
                createCertificate.center_footer,
                createCertificate.background_image,
                createCertificate.created_for,
                createCertificate.status,
                createCertificate.header_height,
                createCertificate.content_height,
                createCertificate.footer_height,
                createCertificate.content_width,
                createCertificate.enable_patient_image,
                createCertificate.enable_image_height
            ]);
            certificates_id = certificate.insertId;
            await this.dynamicConnection.query(`INSERT into certificates (
certificate_name,
certificate_text,
left_header,
center_header,
right_header,
left_footer,
right_footer,
center_footer,
background_image,
created_for,
status,
header_height,
content_height,
footer_height,
content_width,
enable_patient_image,
enable_image_height,
hospital_id,
hos_certificates_id
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createCertificate.certificate_name,
                createCertificate.certificate_text,
                createCertificate.left_header,
                createCertificate.center_header,
                createCertificate.right_header,
                createCertificate.left_footer,
                createCertificate.right_footer,
                createCertificate.center_footer,
                createCertificate.background_image,
                createCertificate.created_for,
                createCertificate.status,
                createCertificate.header_height,
                createCertificate.content_height,
                createCertificate.footer_height,
                createCertificate.content_width,
                createCertificate.enable_patient_image,
                createCertificate.enable_image_height,
                createCertificate.hospital_id,
                certificates_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Certificate details added successfully ",
                        "Certificates_values": await this.connection.query('SELECT * FROM certificates where id = ?', [certificates_id])
                    }
                }];
        }
        catch (error) {
            console.error('Error inserting data:', error);
        }
    }
    async updateCertificates(id, createCertificate) {
        try {
            const fromDate = new Date();
            const timestamp = fromDate.toISOString().replace('T', ' ').replace(/\.\d+Z$/, '');
            await this.connection.query(`update certificates SET
certificate_name=?,
certificate_text=?,
left_header=?,
center_header=?,
right_header=?,
left_footer=?,
right_footer=?,
center_footer=?,
background_image=?,
created_for=?,
status=?,
header_height=?,
content_height=?,
footer_height=?,
content_width=?,
enable_patient_image=?,
enable_image_height=?,
updated_at=?
where id=?`, [
                createCertificate.certificate_name,
                createCertificate.certificate_text,
                createCertificate.left_header,
                createCertificate.center_header,
                createCertificate.right_header,
                createCertificate.left_footer,
                createCertificate.right_footer,
                createCertificate.center_footer,
                createCertificate.background_image,
                createCertificate.created_for,
                createCertificate.status,
                createCertificate.header_height,
                createCertificate.content_height,
                createCertificate.footer_height,
                createCertificate.content_width,
                createCertificate.enable_patient_image,
                createCertificate.enable_image_height,
                timestamp,
                id
            ]);
            const dyncertificate = await this.dynamicConnection.query('SELECT id FROM certificates WHERE hos_certificates_id=? and hospital_id=?', [id, createCertificate.hospital_id]);
            const dynCertificateID = dyncertificate[0].id;
            await this.dynamicConnection.query(`update certificates SET
certificate_name=?,
certificate_text=?,
left_header=?,
center_header=?,
right_header=?,
left_footer=?,
right_footer=?,
center_footer=?,
background_image=?,
created_for=?,
status=?,
header_height=?,
content_height=?,
footer_height=?,
content_width=?,
enable_patient_image=?,
enable_image_height=?,
updated_at=?,
hospital_id=?
where id=?`, [
                createCertificate.certificate_name,
                createCertificate.certificate_text,
                createCertificate.left_header,
                createCertificate.center_header,
                createCertificate.right_header,
                createCertificate.left_footer,
                createCertificate.right_footer,
                createCertificate.center_footer,
                createCertificate.background_image,
                createCertificate.created_for,
                createCertificate.status,
                createCertificate.header_height,
                createCertificate.content_height,
                createCertificate.footer_height,
                createCertificate.content_width,
                createCertificate.enable_patient_image,
                createCertificate.enable_image_height,
                timestamp,
                createCertificate.hospital_id,
                dynCertificateID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Certificate details updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM certificates WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async removeCertificates(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM certificates WHERE id = ?', [id]);
            const [GetDynCertificates] = await this.dynamicConnection.query('SELECT id FROM certificates WHERE hos_certificates_id=? and hospital_id=?', [id, hospital_id]);
            const GetDynCertificatesID = GetDynCertificates.id;
            await this.dynamicConnection.query('DELETE FROM certificates WHERE id = ?', [GetDynCertificatesID]);
            return [
                {
                    status: 'success',
                    message: `Certificates with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
};
exports.CertificatesService = CertificatesService;
exports.CertificatesService = CertificatesService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], CertificatesService);
//# sourceMappingURL=certificates.service.js.map