"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BillingFilterService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let BillingFilterService = class BillingFilterService {
    constructor(connection) {
        this.connection = connection;
    }
    async findAll(date, fromDate, todate, patient_id, payment_method) {
        let query = `select transactions.id as s_no, transactions.patient_id as Patient_ID, patients.patient_name as Patient_Name, 
transactions.payment_mode as payment_method,transactions.payment_date as date from transactions
left join patients on transactions.patient_id = patients.id `;
        let values = [];
        if (fromDate && todate) {
            date = `date(transactions.payment_date) >= date ('` + fromDate + `') and date(transactions.payment_date) <= date ('` + todate + `')`;
        }
        else if (fromDate) {
            date = `date(transactions.payment_date) >= date ('` + fromDate + `')`;
        }
        else if (todate) {
            date = `date(transactions.payment_date) <= date ('` + todate + `')`;
        }
        else {
            date = ` date(transactions.payment_date) < Date(Now()) `;
        }
        let where = `where ` + date;
        if (patient_id) {
            where += ` and transactions.patient_id = ?`;
            values.push(patient_id);
        }
        if (payment_method) {
            where += ` and transactions.payment_mode = ?`;
            values.push(payment_method);
        }
        let order = ` order by transactions.payment_date asc `;
        let final = query + where + order;
        try {
            const billing_filter = await this.connection.query(final, values);
            return billing_filter;
        }
        catch (error) {
            return error;
        }
    }
};
exports.BillingFilterService = BillingFilterService;
exports.BillingFilterService = BillingFilterService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], BillingFilterService);
//# sourceMappingURL=billing_filter.service.js.map