import { DataSource } from 'typeorm';
import { Billing } from './entities/billing.entity';
import { CountDto } from './dto/billing.dto';
export declare class BillingService {
    private readonly connection;
    private readonly dynamicConnection;
    constructor(connection: DataSource, dynamicConnection: DataSource);
    create(Entity: Billing): Promise<any>;
    findall(patient_id: number): Promise<any>;
    findone(patient_id: number): Promise<any>;
    findamount(patient_id: number): Promise<any>;
    findBillingDetailsByIpdId(ipd_id: number, search: string, limit: number, page: number): Promise<CountDto>;
    findBillingDetailsByOpdId(opd_id: number, search: string, limit: number, page: number): Promise<CountDto>;
    findBillingDetailsByCaseReferenceId(case_reference_id: string, search: string, ipd_limit: number, ipd_page: number, opd_limit: number, opd_page: number): Promise<any>;
    findBillingDetailsByPatientId(patient_id: string, search: string, ipd_limit: number, ipd_page: number, opd_limit: number, opd_page: number): Promise<any>;
}
