"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BillingController = void 0;
const common_1 = require("@nestjs/common");
const billing_service_1 = require("./billing.service");
const billing_entity_1 = require("./entities/billing.entity");
const auth_guard_1 = require("../auth/auth.guard");
let BillingController = class BillingController {
    constructor(billingService) {
        this.billingService = billingService;
    }
    create(Entity) {
        return this.billingService.create(Entity);
    }
    findAll(patient_id) {
        return this.billingService.findall(patient_id);
    }
    findome(patient_id) {
        return this.billingService.findone(patient_id);
    }
    findamount(patient_id) {
        return this.billingService.findamount(patient_id);
    }
    async findBillingDetailsByIpdId(ipd_id, search, limit, page) {
        try {
            if (!ipd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'IPD ID is required',
                };
            }
            const final_out = await this.billingService.findBillingDetailsByIpdId(ipd_id, search, limit, page);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    patientInfo: final_out.patientInfo,
                    total: final_out.total,
                    totalTaxAmount: final_out.totalTaxAmount,
                    totalApplyCharge: final_out.totalApplyCharge,
                    totalAmount: final_out.totalAmount,
                    paid: final_out.paid,
                    unpaid: final_out.unpaid,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findBillingDetailsByOpdId(opd_id, search, limit, page) {
        try {
            if (!opd_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'OPD ID is required',
                };
            }
            const final_out = await this.billingService.findBillingDetailsByOpdId(opd_id, search, limit, page);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    patientInfo: final_out.patientInfo,
                    total: final_out.total,
                    totalTaxAmount: final_out.totalTaxAmount,
                    totalApplyCharge: final_out.totalApplyCharge,
                    totalAmount: final_out.totalAmount,
                    paid: final_out.paid,
                    unpaid: final_out.unpaid,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findBillingDetailsByCaseReference(case_reference_id, search, ipd_limit, ipd_page, opd_limit, opd_page) {
        try {
            if (!case_reference_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'Case Reference ID is required',
                };
            }
            const final_out = await this.billingService.findBillingDetailsByCaseReferenceId(case_reference_id, search, ipd_limit, ipd_page, opd_limit, opd_page);
            return {
                status_code: process.env.SUCCESS_STATUS_CODE,
                status: process.env.SUCCESS_STATUS,
                message: process.env.SUCCESS_MESSAGE,
                data: final_out,
            };
        }
        catch (error) {
            console.error(error, 'Billing Error');
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findBillingDetailsByPatientId(patient_id, search, ipd_limit, ipd_page, opd_limit, opd_page) {
        try {
            if (!patient_id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'Patient ID is required',
                };
            }
            const final_out = await this.billingService.findBillingDetailsByPatientId(patient_id, search, ipd_limit, ipd_page, opd_limit, opd_page);
            return {
                status_code: process.env.SUCCESS_STATUS_CODE,
                status: process.env.SUCCESS_STATUS,
                message: process.env.SUCCESS_MESSAGE,
                data: final_out,
            };
        }
        catch (error) {
            console.error(error, 'Billing Error');
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.BillingController = BillingController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [billing_entity_1.Billing]),
    __metadata("design:returntype", void 0)
], BillingController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('patient_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], BillingController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/details'),
    __param(0, (0, common_1.Query)('patient_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], BillingController.prototype, "findome", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/amount'),
    __param(0, (0, common_1.Query)('patient_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], BillingController.prototype, "findamount", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_billing_details_by_ipdID'),
    __param(0, (0, common_1.Query)('ipd_id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], BillingController.prototype, "findBillingDetailsByIpdId", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_billing_details_by_opdID'),
    __param(0, (0, common_1.Query)('opd_id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], BillingController.prototype, "findBillingDetailsByOpdId", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_billing_details_by_case_reference'),
    __param(0, (0, common_1.Query)('case_reference_id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('ipd_limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('ipd_page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __param(4, (0, common_1.Query)('opd_limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(5, (0, common_1.Query)('opd_page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], BillingController.prototype, "findBillingDetailsByCaseReference", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_billing_details_by_patient_id'),
    __param(0, (0, common_1.Query)('patient_id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('ipd_limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('ipd_page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __param(4, (0, common_1.Query)('opd_limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(5, (0, common_1.Query)('opd_page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], BillingController.prototype, "findBillingDetailsByPatientId", null);
exports.BillingController = BillingController = __decorate([
    (0, common_1.Controller)('billing'),
    __metadata("design:paramtypes", [billing_service_1.BillingService])
], BillingController);
//# sourceMappingURL=billing.controller.js.map