"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BedHistoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let BedHistoryService = class BedHistoryService {
    constructor(connection) {
        this.connection = connection;
    }
    async findBedHistory(id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM ipd_details WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.VALIDATION_NOT_FOUND,
                message: `${process.env.VALIDATION_CHECK} ${id} ${process.env.VALIDATION_DUPLICATE_CHECK} `,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const getBedHistoryByID = await this.connection.query(`SELECT bed_group.name AS BedGroup, 
    bed.name AS Bed, 
    patient_bed_history.from_date AS FromDate, 
    patient_bed_history.to_date AS ToDate,
    patient_bed_history.is_active AS ActiveBed,
    patient_bed_history.case_reference_id,
    ipd_details.id
    FROM patient_bed_history
    LEFT JOIN bed_group ON patient_bed_history.bed_group_id = bed_group.id
    LEFT JOIN bed ON patient_bed_history.bed_id = bed.id
    LEFT JOIN case_references ON patient_bed_history.case_reference_id = case_references.id
    left join ipd_details on ipd_details.case_reference_id = case_references.id
    WHERE ipd_details.id = ?`, [id]);
            return getBedHistoryByID;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE_V2,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findBedHistorySearch(id, search) {
        const [existingRecord] = await this.connection.query('SELECT id FROM ipd_details WHERE id = ?', [id]);
        if (!existingRecord || existingRecord.length === 0) {
            throw new common_1.HttpException({
                status: process.env.VALIDATION_NOT_FOUND,
                message: `${process.env.VALIDATION_CHECK} ${id} ${process.env.VALIDATION_DUPLICATE_CHECK} `,
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            let query = `SELECT bed_group.name AS BedGroup, 
      bed.name AS Bed, 
      patient_bed_history.from_date AS FromDate, 
      patient_bed_history.to_date AS ToDate,
      patient_bed_history.is_active AS ActiveBed,
      patient_bed_history.case_reference_id,
      ipd_details.id
      FROM patient_bed_history
      LEFT JOIN bed_group ON patient_bed_history.bed_group_id = bed_group.id
      LEFT JOIN bed ON patient_bed_history.bed_id = bed.id
      LEFT JOIN case_references ON patient_bed_history.case_reference_id = case_references.id
      left join ipd_details on ipd_details.case_reference_id = case_references.id
      WHERE ipd_details.id = ?`;
            let values = [];
            values.push(id);
            if (search) {
                query += `  and (bed.name like ? or patient_bed_history.from_date like ? or patient_bed_history.to_date like ? or patient_bed_history.is_active like ? or bed_group.name like ?)  `;
                values.push('%' + search + '%');
                values.push('%' + search + '%');
                values.push('%' + search + '%');
                values.push('%' + search + '%');
                values.push('%' + search + '%');
            }
            const getBedHistorysch = await this.connection.query(query, values);
            return getBedHistorysch;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE_V2,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findIpdBedHistoryDetails(id, search, limit, page) {
        const offset = limit * (page - 1);
        let values = [id];
        let searchValues = [];
        try {
            let baseQuery = `
        SELECT bed_group.name AS BedGroup, 
      bed.name AS Bed, 
      patient_bed_history.from_date AS FromDate, 
      patient_bed_history.to_date AS ToDate,
      patient_bed_history.is_active AS ActiveBed,
      patient_bed_history.case_reference_id,
      ipd_details.id
      FROM patient_bed_history
      LEFT JOIN bed_group ON patient_bed_history.bed_group_id = bed_group.id
      LEFT JOIN bed ON patient_bed_history.bed_id = bed.id
      LEFT JOIN case_references ON patient_bed_history.case_reference_id = case_references.id
      left join ipd_details on ipd_details.case_reference_id = case_references.id
      WHERE ipd_details.id = ?`;
            let countQuery = `
        SELECT COUNT(patient_bed_history.id) AS total
        FROM patient_bed_history
      LEFT JOIN bed_group ON patient_bed_history.bed_group_id = bed_group.id
      LEFT JOIN bed ON patient_bed_history.bed_id = bed.id
      LEFT JOIN case_references ON patient_bed_history.case_reference_id = case_references.id
      left join ipd_details on ipd_details.case_reference_id = case_references.id
      WHERE ipd_details.id = ?`;
            if (search) {
                const condition = `
          and (bed.name like ? or patient_bed_history.from_date like ? or patient_bed_history.to_date like ? or patient_bed_history.is_active like ? or bed_group.name like ?)`;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                searchValues = Array(5).fill(pattern);
                values = [id, ...searchValues];
            }
            baseQuery += ` ORDER BY patient_bed_history.to_date DESC LIMIT ? OFFSET ?`;
            const paginatedValues = [...values, limit, offset];
            const ipdBedHistory = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: ipdBedHistory,
                total: countResult?.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE_V2,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findIpdBedHistoryDetail(id, search, limit, page) {
        const offset = limit * (page - 1);
        let values = [id];
        let searchValues = [];
        try {
            let baseQuery = `
        SELECT bed_group.name AS BedGroup, 
      bed.name AS Bed, 
      patient_bed_history.from_date AS FromDate, 
      patient_bed_history.to_date AS ToDate,
      patient_bed_history.is_active AS ActiveBed,
      patient_bed_history.case_reference_id,
      ipd_details.id
      FROM patient_bed_history
      LEFT JOIN bed_group ON patient_bed_history.bed_group_id = bed_group.id
      LEFT JOIN bed ON patient_bed_history.bed_id = bed.id
      LEFT JOIN case_references ON patient_bed_history.case_reference_id = case_references.id
      left join ipd_details on ipd_details.case_reference_id = case_references.id
      WHERE ipd_details.id = ?`;
            let countQuery = `
        SELECT COUNT(patient_bed_history.id) AS total
        FROM patient_bed_history
      LEFT JOIN bed_group ON patient_bed_history.bed_group_id = bed_group.id
      LEFT JOIN bed ON patient_bed_history.bed_id = bed.id
      LEFT JOIN case_references ON patient_bed_history.case_reference_id = case_references.id
      left join ipd_details on ipd_details.case_reference_id = case_references.id
      WHERE ipd_details.id = ?`;
            if (search) {
                const condition = `
          and (bed.name like ? or patient_bed_history.from_date like ? or patient_bed_history.to_date like ? or patient_bed_history.is_active like ? or bed_group.name like ?)`;
                baseQuery += condition;
                countQuery += condition;
                const pattern = `%${search}%`;
                searchValues = Array(5).fill(pattern);
                values = [id, ...searchValues];
            }
            baseQuery += ` ORDER BY patient_bed_history.to_date DESC LIMIT ? OFFSET ?`;
            const paginatedValues = [...values, limit, offset];
            const ipdBedHistory = await this.connection.query(baseQuery, paginatedValues);
            const [countResult] = await this.connection.query(countQuery, values);
            return {
                details: ipdBedHistory,
                total: countResult?.total ?? 0,
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE_V2,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.BedHistoryService = BedHistoryService;
exports.BedHistoryService = BedHistoryService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [typeorm_1.DataSource])
], BedHistoryService);
//# sourceMappingURL=bed_history.service.js.map