"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BedHistoryController = void 0;
const common_1 = require("@nestjs/common");
const bed_history_service_1 = require("./bed_history.service");
const auth_guard_1 = require("../auth/auth.guard");
let BedHistoryController = class BedHistoryController {
    constructor(bedHistoryService) {
        this.bedHistoryService = bedHistoryService;
    }
    findBedHistory(id) {
        return this.bedHistoryService.findBedHistory(id);
    }
    findBedHistorySearch(id, search) {
        return this.bedHistoryService.findBedHistorySearch(id, search);
    }
    async findIpdBedHistoryDetails(id, search, limit, page) {
        try {
            if (!id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'IPD ID is required',
                };
            }
            const final_out = await this.bedHistoryService.findIpdBedHistoryDetails(id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async findIpdBedHistoryDetail(id, search, limit, page) {
        try {
            if (!id) {
                return {
                    status_code: process.env.BAD_REQUEST_CODE,
                    status: process.env.BAD_REQUEST_STATUS,
                    message: 'IPD ID is required',
                };
            }
            const final_out = await this.bedHistoryService.findIpdBedHistoryDetail(id, search, limit || 10, page || 1);
            if (final_out.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.DATA_NOT_FOUND,
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
};
exports.BedHistoryController = BedHistoryController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], BedHistoryController.prototype, "findBedHistory", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/BedHistory/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], BedHistoryController.prototype, "findBedHistorySearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/get_ipd_bed_history'),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], BedHistoryController.prototype, "findIpdBedHistoryDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v3/get_ipd_bed_history'),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('search')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('page', new common_1.DefaultValuePipe(1), common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number]),
    __metadata("design:returntype", Promise)
], BedHistoryController.prototype, "findIpdBedHistoryDetail", null);
exports.BedHistoryController = BedHistoryController = __decorate([
    (0, common_1.Controller)('bed-history'),
    __metadata("design:paramtypes", [bed_history_service_1.BedHistoryService])
], BedHistoryController);
//# sourceMappingURL=bed_history.controller.js.map