"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthGuard = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
let AuthGuard = class AuthGuard {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async canActivate(context) {
        try {
            const request = context.switchToHttp().getRequest();
            const tokenFromHeader = request.headers['authorization'];
            if (!tokenFromHeader) {
                return false;
            }
            const [getToken] = await this.dynamicConnection.query(`SELECT authToken FROM op_hub_staff_login_auth_tokens WHERE authToken = ? and authTokenExpiry >= now()`, [tokenFromHeader]);
            if (!getToken) {
                return false;
            }
            const accToken = await getToken.authToken;
            if (tokenFromHeader === accToken) {
                return true;
            }
            else {
                return false;
            }
        }
        catch (error) {
            console.error('Error in AuthGuard:', error);
            return false;
        }
    }
};
exports.AuthGuard = AuthGuard;
exports.AuthGuard = AuthGuard = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_2.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_1.DataSource,
        typeorm_1.DataSource])
], AuthGuard);
//# sourceMappingURL=auth.guard.js.map