"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateAswinAiHospitalOnboardDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
class CreateAswinAiHospitalOnboardDto {
}
exports.CreateAswinAiHospitalOnboardDto = CreateAswinAiHospitalOnboardDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Health Facility ID', example: 'HF123456' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "HealthFacilityID", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Hospital Name', example: 'Apollo Hospitals' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hospital_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Contact Number', example: '9876543210' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "contact_no", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Consulting Charge', example: '200', default: '200' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hospital_consulting_charge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Opening Timing', example: '08:00 AM' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hospital_opening_timing", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Closing Timing', example: '08:00 PM' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hospital_closing_timing", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Address', example: '123 Main Street, Chennai' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "address", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'State', example: 'Tamil Nadu' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "state", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'District', example: 'Chennai' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "district", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Pincode', example: '600001' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "pincode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Website URL', example: 'https://www.apollohospitals.com' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "website", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Email ID', example: 'info@apollo.com' }),
    (0, class_validator_1.IsEmail)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Registration Number', example: 'TNHOSP001' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hospital_reg_no", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Registration Date', example: '2022-01-01' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hospital_reg_date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Registration Expiry Date', example: '2030-01-01' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hospital_reg_expiry_date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Specialties as JSON array', example: '["Cardiology", "Neurology"]', type: 'array', isArray: true }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Object)
], CreateAswinAiHospitalOnboardDto.prototype, "specialty", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Array of Image path or URL', example: ['image1.jpg', 'image2.jpg'] }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Object)
], CreateAswinAiHospitalOnboardDto.prototype, "image", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Logo path or URL', example: '/uploads/logo.png' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "logo", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Total number of beds', example: 100 }),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], CreateAswinAiHospitalOnboardDto.prototype, "bedcount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Overview of the hospital', example: 'Multi-specialty hospital established in 1990' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "overview", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Tax percentage', example: '18%' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "tax_percentage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Tax amount', example: '36.00' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "tax_amount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Latitude', example: '13.0827' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "lattitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Longitude', example: '80.2707' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "longitude", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'HIP ID', example: 'HIP0001234' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hip_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Hospital Type', example: 'Clinic' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hospital_type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'hospital certificate', example: 'certifiate.pdf' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hospital_certificate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'country', example: 'India' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "country", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'HIP Name', example: 'Apollo HIP' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "hip_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'PHR API Base URL', example: 'https://phr.apollo.com/api' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "phr_api_base_url", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'OP Hub Base URL', example: 'https://ophub.apollo.com' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "op_hub_base_url", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'secondary mobile no', example: '7092327667' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "secondary_mobile_no", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'secondary mobile no', example: '7092327667' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "primary_mobile_no_country_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'secondary mobile no', example: '7092327667' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateAswinAiHospitalOnboardDto.prototype, "secondary_mobile_no_country_code", void 0);
//# sourceMappingURL=create-aswin-ai-hospital-onboard.dto.js.map