"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AswinAiHospitalOnboardService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let AswinAiHospitalOnboardService = class AswinAiHospitalOnboardService {
    constructor(connection) {
        this.connection = connection;
    }
    async create(createAswinAiHospitalOnboardDto) {
        try {
            const insertHospital = await this.connection.query(`insert into hospitals (
      HealthFacilityID,
      hospital_name,
      contact_no,
      hospital_consulting_charge,
      hospital_opening_timing,
      hospital_closing_timing,
      address,
      state,
      district,
      pincode,
      website,
      email,
      hospital_reg_no,
      hospital_reg_date,
      hospital_reg_expiry_date,
      specialty,
      logo,
      bedcount,
      overview,
      tax_percentage,
      tax_amount,
      lattitude,
      longitude,
      country,
      hospital_type,
      hospital_certificate,
      secondary_mobile_no,
      primary_mobile_no_country_code,
      secondary_mobile_no_country_code
      ) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [
                createAswinAiHospitalOnboardDto.HealthFacilityID || "HF" + Math.floor(Math.random() * 1000000),
                createAswinAiHospitalOnboardDto.hospital_name,
                createAswinAiHospitalOnboardDto.contact_no,
                createAswinAiHospitalOnboardDto.hospital_consulting_charge || 0,
                createAswinAiHospitalOnboardDto.hospital_opening_timing,
                createAswinAiHospitalOnboardDto.hospital_closing_timing,
                createAswinAiHospitalOnboardDto.address,
                createAswinAiHospitalOnboardDto.state,
                createAswinAiHospitalOnboardDto.district,
                createAswinAiHospitalOnboardDto.pincode,
                createAswinAiHospitalOnboardDto.website || "",
                createAswinAiHospitalOnboardDto.email,
                createAswinAiHospitalOnboardDto.hospital_reg_no,
                createAswinAiHospitalOnboardDto.hospital_reg_date,
                createAswinAiHospitalOnboardDto.hospital_reg_expiry_date,
                createAswinAiHospitalOnboardDto.specialty,
                createAswinAiHospitalOnboardDto.logo || "",
                createAswinAiHospitalOnboardDto.bedcount || 0,
                createAswinAiHospitalOnboardDto.overview || "",
                createAswinAiHospitalOnboardDto.tax_percentage || 0,
                createAswinAiHospitalOnboardDto.tax_amount || 0,
                createAswinAiHospitalOnboardDto.lattitude,
                createAswinAiHospitalOnboardDto.longitude,
                createAswinAiHospitalOnboardDto.country,
                createAswinAiHospitalOnboardDto.hospital_type,
                createAswinAiHospitalOnboardDto.hospital_certificate,
                createAswinAiHospitalOnboardDto.secondary_mobile_no,
                createAswinAiHospitalOnboardDto.primary_mobile_no_country_code,
                createAswinAiHospitalOnboardDto.secondary_mobile_no_country_code
            ]);
            for (const a of createAswinAiHospitalOnboardDto.image) {
                if (a) {
                    this.connection.query(`insert into hospital_images (hospital_id, hospital_images) values(?,?)`, [insertHospital.insertId, a]);
                }
            }
            return insertHospital;
        }
        catch (error) {
            console.log(error, 'Error in createAswinAiHospitalOnboardDto');
            return error;
        }
    }
    findAll() {
        return `This action returns all aswinAiHospitalOnboard`;
    }
    findOne(id) {
        return `This action returns a #${id} aswinAiHospitalOnboard`;
    }
    update(id, updateAswinAiHospitalOnboardDto) {
        return `This action updates a #${id} aswinAiHospitalOnboard`;
    }
    remove(id) {
        return `This action removes a #${id} aswinAiHospitalOnboard`;
    }
};
exports.AswinAiHospitalOnboardService = AswinAiHospitalOnboardService;
exports.AswinAiHospitalOnboardService = AswinAiHospitalOnboardService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectDataSource)('aswinConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource])
], AswinAiHospitalOnboardService);
//# sourceMappingURL=aswin-ai-hospital-onboard.service.js.map