"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AswinAiHospitalOnboardController = void 0;
const common_1 = require("@nestjs/common");
const aswin_ai_hospital_onboard_service_1 = require("./aswin-ai-hospital-onboard.service");
const create_aswin_ai_hospital_onboard_dto_1 = require("./dto/create-aswin-ai-hospital-onboard.dto");
const update_aswin_ai_hospital_onboard_dto_1 = require("./dto/update-aswin-ai-hospital-onboard.dto");
let AswinAiHospitalOnboardController = class AswinAiHospitalOnboardController {
    constructor(aswinAiHospitalOnboardService) {
        this.aswinAiHospitalOnboardService = aswinAiHospitalOnboardService;
    }
    async create(createAswinAiHospitalOnboardDto) {
        if (!createAswinAiHospitalOnboardDto.hospital_name ||
            !createAswinAiHospitalOnboardDto.contact_no ||
            !createAswinAiHospitalOnboardDto.hospital_opening_timing ||
            !createAswinAiHospitalOnboardDto.address ||
            !createAswinAiHospitalOnboardDto.pincode ||
            !createAswinAiHospitalOnboardDto.email ||
            !createAswinAiHospitalOnboardDto.hospital_reg_no ||
            !createAswinAiHospitalOnboardDto.hospital_reg_date ||
            !createAswinAiHospitalOnboardDto.country ||
            !createAswinAiHospitalOnboardDto.hospital_type ||
            !createAswinAiHospitalOnboardDto.hospital_certificate ||
            !createAswinAiHospitalOnboardDto.primary_mobile_no_country_code) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING
            };
        }
        if (createAswinAiHospitalOnboardDto.contact_no == createAswinAiHospitalOnboardDto.secondary_mobile_no) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING,
                status: process.env.ERROR_STATUS,
                message: "Primary and Secondary mobile numbers cannot be the same."
            };
        }
        try {
            const getOut = await this.aswinAiHospitalOnboardService.create(createAswinAiHospitalOnboardDto);
            if (getOut && getOut.affectedRows > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_INSERT_V2,
                    data: getOut.insertId
                };
            }
            else {
                return {
                    status_code: process.env.ERROR_STATUS_CODE_V2,
                    status: process.env.ERROR_STATUS_V2,
                    message: process.env.ERROR_MESSAGE_V2,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    findAll() {
        return this.aswinAiHospitalOnboardService.findAll();
    }
    findOne(id) {
        return this.aswinAiHospitalOnboardService.findOne(+id);
    }
    update(id, updateAswinAiHospitalOnboardDto) {
        return this.aswinAiHospitalOnboardService.update(+id, updateAswinAiHospitalOnboardDto);
    }
    remove(id) {
        return this.aswinAiHospitalOnboardService.remove(+id);
    }
};
exports.AswinAiHospitalOnboardController = AswinAiHospitalOnboardController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_aswin_ai_hospital_onboard_dto_1.CreateAswinAiHospitalOnboardDto]),
    __metadata("design:returntype", Promise)
], AswinAiHospitalOnboardController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], AswinAiHospitalOnboardController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AswinAiHospitalOnboardController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_aswin_ai_hospital_onboard_dto_1.UpdateAswinAiHospitalOnboardDto]),
    __metadata("design:returntype", void 0)
], AswinAiHospitalOnboardController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AswinAiHospitalOnboardController.prototype, "remove", null);
exports.AswinAiHospitalOnboardController = AswinAiHospitalOnboardController = __decorate([
    (0, common_1.Controller)('aswin-ai-hospital-onboard'),
    __metadata("design:paramtypes", [aswin_ai_hospital_onboard_service_1.AswinAiHospitalOnboardService])
], AswinAiHospitalOnboardController);
//# sourceMappingURL=aswin-ai-hospital-onboard.controller.js.map