"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppointmentStatusService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
let AppointmentStatusService = class AppointmentStatusService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(AppointmentStatusEntity) {
        try {
            const result = await this.connection.query('insert into appointment_status (status,color_code) values (?,?)', [AppointmentStatusEntity.status, AppointmentStatusEntity.color_code]);
            await this.dynamicConnection.query(`Insert into appointment_status(status,color_code,hospital_id,hos_appointment_status_id) values (?,?,?,?)`, [
                AppointmentStatusEntity.status,
                AppointmentStatusEntity.color_code,
                AppointmentStatusEntity.hospital_id,
                result.insertId,
            ]);
            return [
                {
                    data: {
                        'id  ': result.insertId,
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.SUCCESS_MESSAGE_INSERT_V2,
                        inserted_data: await this.connection.query('SELECT * FROM appointment_status WHERE id = ?', [result.insertId]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAll() {
        try {
            const appointment_status = await this.connection.query(`select appointment_status.id as id, appointment_status.status as status, appointment_status.color_code 
from appointment_status`);
            return appointment_status;
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findone(id) {
        try {
            const appointment_status = await this.connection.query(`select appointment_status.id as id, appointment_status.status as status, appointment_status.color_code 
from appointment_status where id = ?`, [id]);
            return appointment_status;
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, AppointmentStatusEntity) {
        try {
            await this.connection.query(`update appointment_status SET status = ?, color_code = ? WHERE id = ?`, [
                AppointmentStatusEntity.status,
                AppointmentStatusEntity.color_code,
                id,
            ]);
            await this.dynamicConnection.query(`update appointment_status SET  status = ?, color_code = ? where hos_appointment_status_id = ? and hospital_id = ?`, [
                AppointmentStatusEntity.status,
                AppointmentStatusEntity.color_code,
                id,
                AppointmentStatusEntity.hospital_id,
            ]);
            return [
                {
                    'data ': {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.APPOINTMENT_STATUS,
                        updated_values: await this.connection.query('SELECT * FROM appointment_status WHERE id = ?', [id]),
                    },
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findAllstatus() {
        try {
            const appointment_status = await this.connection.query(`select * from appointment_status`);
            return appointment_status;
        }
        catch (error) {
            throw new common_1.HttpException({
                statuscode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.AppointmentStatusService = AppointmentStatusService;
exports.AppointmentStatusService = AppointmentStatusService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_2.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_1.DataSource,
        typeorm_1.DataSource])
], AppointmentStatusService);
//# sourceMappingURL=appointment_status.service.js.map