"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let AppService = class AppService {
    constructor(dynamicConnection, connection) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
    }
    async onModuleInit() {
        try {
            await this.connection.query(`
        CREATE TABLE IF NOT EXISTS user_payment_summary(
          id INT AUTO_INCREMENT PRIMARY KEY,
          user_id INT,
          wallet_amount_paid varchar(50),
          paid_amount varchar(50),
          due_amount varchar(50),
          actual_amount_paid varchar(50),
          total_online_payments varchar(50),
          total_offline_payments varchar(50),
          total_billed_amount varchar(50),
          total_tax_amount varchar(50),
          overall_subtotal_amount varchar(50),
          created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )
      `);
        }
        catch (error) {
            console.error('Failed to create user_payment_summary table :', error.message);
        }
        try {
            await this.connection.query(`
        CREATE TABLE IF NOT EXISTS patient_payment_summary(
          id INT AUTO_INCREMENT PRIMARY KEY,
          patient_id INT,
          wallet_amount_paid varchar(50),
          paid_amount varchar(50),
          due_amount varchar(50),
          actual_amount_paid varchar(50),
          total_online_payments varchar(50),
          total_offline_payments varchar(50),
          total_billed_amount varchar(50),
          total_tax_amount varchar(50),
          overall_subtotal_amount varchar(50),
          created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )
      `);
        }
        catch (error) {
            console.error('Failed to create patient_payment_summary :', error.message);
        }
        try {
            await this.dynamicConnection.query(`
        CREATE TABLE IF NOT EXISTS patient_payment_summary(
          id INT AUTO_INCREMENT PRIMARY KEY,
          patient_id INT,
          wallet_amount_paid varchar(50),
          paid_amount varchar(50),
          due_amount varchar(50),
          actual_amount_paid varchar(50),
          total_online_payments varchar(50),
          total_offline_payments varchar(50),
          total_billed_amount varchar(50),
          total_tax_amount varchar(50),
          overall_subtotal_amount varchar(50),
          created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )
      `);
        }
        catch (error) {
            console.error('Failed to create user_payment_summary :', error.message);
        }
        try {
            await this.connection.query(`
        CREATE TABLE IF NOT EXISTS hospital_payment_summary(
          id INT AUTO_INCREMENT PRIMARY KEY,
          hospital_id INT,
          wallet_amount_paid varchar(50),
          paid_amount varchar(50),
          due_amount varchar(50),
          actual_amount_paid varchar(50),
          total_online_payments varchar(50),
          total_offline_payments varchar(50),
          total_billed_amount varchar(50),
          total_tax_amount varchar(50),
          overall_subtotal_amount varchar(50),
          created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )
      `);
            console.log('Tables created successfully');
        }
        catch (error) {
            console.error('Failed to create hospital_payment_summary :', error.message);
        }
        try {
            await this.connection.query(`
    ALTER TABLE patients
    ADD COLUMN existing_patient_id int(10),
    ADD COLUMN employer_id int(15),
    ADD COLUMN employer_name VARCHAR(100),
    ADD COLUMN employee_id int(50),
    ADD COLUMN occupation VARCHAR(100);
  `);
        }
        catch (error) {
            console.error('Failed to update patients table:', error.message);
        }
        try {
            await this.dynamicConnection.query(`
    ALTER TABLE patients
    ADD COLUMN existing_patient_id int(10),
    ADD COLUMN employer_id int(15),
    ADD COLUMN employer_name VARCHAR(100),
    ADD COLUMN employee_id int(50),
    ADD COLUMN occupation VARCHAR(100);
  `);
        }
        catch (error) {
            console.error('Failed to update patients table:', error.message);
        }
        try {
            await this.dynamicConnection.query(`
    ALTER TABLE patients
MODIFY COLUMN created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;
  `);
        }
        catch (error) {
            console.error('Failed to update patients table:', error.message);
        }
        try {
            await this.connection.query(`
    ALTER TABLE patients
MODIFY COLUMN created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;
  `);
        }
        catch (error) {
            console.error('Failed to update patients table:', error.message);
        }
        try {
            await this.connection.query(`
       
    CREATE TABLE IF NOT EXISTS aayush_coins  (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    total_coins_used INT NOT NULL DEFAULT 0,
    total_coins_remaining INT NOT NULL DEFAULT 0,
    total_coins_issued INT NOT NULL DEFAULT 0,
    coins_expiry_time DATETIME NOT NULL,
    is_expired BOOLEAN NOT NULL DEFAULT FALSE,
    coins_usage ENUM('fully_used', 'partially_used', 'not_used') NOT NULL DEFAULT 'not_used',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY (id)
)`);
        }
        catch (error) {
            console.error('Failed to create aayush_coins table :', error.message);
        }
        try {
            await this.connection.query(`ALTER TABLE plenome_ADMIN.users 
CHANGE COLUMN password password VARCHAR(50) NULL `);
        }
        catch (error) {
            console.error('Failed to alter user table :', error.message);
        }
        try {
            await this.connection.query(`ALTER TABLE plenome_ADMIN.users 
CHANGE COLUMN has_mpin has_mpin TINYINT(1) NULL DEFAULT 0 ;`);
        }
        catch (error) {
            console.error('Failed to alter user table :', error.message);
        }
        try {
            await this.dynamicConnection.query(`
    CREATE TABLE IF NOT EXISTS opd_voice_data (
      id INT UNSIGNED NOT NULL AUTO_INCREMENT,
      aayush_unique_id VARCHAR(50) NOT NULL,
      user_id INT NOT NULL,
      type ENUM('general','dental') NOT NULL,
      transcript_id VARCHAR(50) DEFAULT NULL,
      opd_details_id INT NOT NULL,
      data JSON DEFAULT NULL,
      audio_file TEXT,
      hospital_id INT DEFAULT NULL,
      created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
      updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      PRIMARY KEY (id),
      KEY fk_opd_details (opd_details_id),
      CONSTRAINT fk_opd_details FOREIGN KEY (opd_details_id) 
        REFERENCES opd_details (id) 
        ON DELETE CASCADE ON UPDATE CASCADE
    );
  `);
            console.log('opd_voice_data table is ready');
        }
        catch (error) {
            console.error('Failed to create opd_voice_data:', error.message);
        }
        try {
            await this.connection.query(`
    ALTER TABLE transactions
    ADD COLUMN actual_paid_amount VARCHAR(100) DEFAULT '0.00',
    ADD COLUMN wallet_paid_amount VARCHAR(100) DEFAULT '0.00'
  `);
        }
        catch (error) {
            console.error('Failed to update transactions table:', error.message);
        }
        try {
            await this.dynamicConnection.query(`
    ALTER TABLE transactions
    ADD COLUMN actual_paid_amount VARCHAR(100) DEFAULT '0.00',
    ADD COLUMN wallet_paid_amount VARCHAR(100) DEFAULT '0.00'
  `);
        }
        catch (error) {
            console.error('Failed to update transactions table:', error.message);
        }
        try {
            await this.connection.query(`
        CREATE TABLE plenome_ADMIN.coin_value (
  id INT NOT NULL AUTO_INCREMENT,
  coin_amount INT NOT NULL DEFAULT 1,  
  currency_code VARCHAR(10) NOT NULL,
  created_at TIMESTAMP NOT NULL DEFAULT current_timestamp,
  PRIMARY KEY (id)
        )
      `);
        }
        catch (error) {
            console.error('Failed to create coin_value table :', error.message);
        }
        try {
            await this.connection.query(`
        ALTER TABLE plenome_ADMIN.aayush_coins 
ADD COLUMN module VARCHAR(50) NULL DEFAULT 'FREE COINS' AFTER updated_at
      `);
        }
        catch (error) {
            console.error('Failed to create coin_value table :', error.message);
        }
    }
    getHello() {
        return 'Hello World!';
    }
};
exports.AppService = AppService;
exports.AppService = AppService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], AppService);
//# sourceMappingURL=app.service.js.map