"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmbulanceListService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let AmbulanceListService = class AmbulanceListService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createAmbulanceList) {
        try {
            const addAmbulanceList = await this.connection.query(`INSERT into vehicles(
       vehicle_no,
       vehicle_model,
       manufacture_year,
       driver_name,
       driver_licence,
       driver_contact,
       note,
       vehicle_type
        ) VALUES (?,?,?,?,?,?,?,?)`, [
                createAmbulanceList.vehicle_no,
                createAmbulanceList.vehicle_model,
                createAmbulanceList.manufacture_year,
                createAmbulanceList.driver_name,
                createAmbulanceList.driver_licence,
                createAmbulanceList.driver_contact,
                createAmbulanceList.note,
                createAmbulanceList.vehicle_type
            ]);
            const addAmbulanceListID = addAmbulanceList.insertId;
            await this.dynamicConnection.query(`INSERT into vehicles(
         vehicle_no,
         vehicle_model,
         manufacture_year,
         driver_name,
         driver_licence,
         driver_contact,
         note,
         vehicle_type,
         hospital_id,
         hos_vehicles_id
          ) VALUES (?,?,?,?,?,?,?,?,?,?)`, [
                createAmbulanceList.vehicle_no,
                createAmbulanceList.vehicle_model,
                createAmbulanceList.manufacture_year,
                createAmbulanceList.driver_name,
                createAmbulanceList.driver_licence,
                createAmbulanceList.driver_contact,
                createAmbulanceList.note,
                createAmbulanceList.vehicle_type,
                createAmbulanceList.hospital_id,
                addAmbulanceListID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Ambulance list details added successfully ",
                        "Ambulance_list_Values": await this.connection.query('SELECT * FROM vehicles WHERE id = ?', [addAmbulanceListID])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async updateAmbulanceList(id, createAmbulanceList) {
        try {
            await this.connection.query(`update vehicles SET
    vehicle_no=?,
    vehicle_model=?,
    manufacture_year=?,
    driver_name=?,
    driver_licence=?,
    driver_contact=?,
    note=?,
    vehicle_type=?
    where id=?`, [
                createAmbulanceList.vehicle_no,
                createAmbulanceList.vehicle_model,
                createAmbulanceList.manufacture_year,
                createAmbulanceList.driver_name,
                createAmbulanceList.driver_licence,
                createAmbulanceList.driver_contact,
                createAmbulanceList.note,
                createAmbulanceList.vehicle_type,
                id
            ]);
            const [dynAmbList] = await this.dynamicConnection.query(`select id from vehicles where hospital_id = ? and  hos_vehicles_id = ?`, [createAmbulanceList.hospital_id, id]);
            const dynAmbListID = dynAmbList.id;
            console.log(dynAmbListID, "dynAmbListIDDDD");
            await this.dynamicConnection.query(`update vehicles SET
    vehicle_no=?,
    vehicle_model=?,
    manufacture_year=?,
    driver_name=?,
    driver_licence=?,
    driver_contact=?,
    note=?,
    vehicle_type=?,
    hospital_id=?
    where id=?`, [
                createAmbulanceList.vehicle_no,
                createAmbulanceList.vehicle_model,
                createAmbulanceList.manufacture_year,
                createAmbulanceList.driver_name,
                createAmbulanceList.driver_licence,
                createAmbulanceList.driver_contact,
                createAmbulanceList.note,
                createAmbulanceList.vehicle_type,
                createAmbulanceList.hospital_id,
                dynAmbListID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Ambulance details updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM vehicles WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async removeAmbulanceList(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM vehicles WHERE id = ?', [id]);
            await this.dynamicConnection.query('DELETE FROM vehicles WHERE hos_vehicles_id = ? AND hospital_id = ?', [id, hospital_id]);
            return [
                {
                    status: 'success',
                    message: `Ambulance list with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
};
exports.AmbulanceListService = AmbulanceListService;
exports.AmbulanceListService = AmbulanceListService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], AmbulanceListService);
//# sourceMappingURL=ambulance_list.service.js.map