import { DataSource } from 'typeorm';
import { AddAppointment, AddAppointmentPayment } from './entities/add-appointment.entity';
import { EventEmitter2 } from '@nestjs/event-emitter';
import { CountDto } from './add-appointment.dto';
import { FaceAuthService } from 'src/face-auth/face-auth.service';
export declare class AddAppointmentService {
    private readonly connection;
    private readonly dynamicConnection;
    private readonly eventEmitter;
    private readonly addAppointmentService;
    constructor(connection: DataSource, dynamicConnection: DataSource, eventEmitter: EventEmitter2, addAppointmentService: FaceAuthService);
    handleOrderCreatedEvent(smsData: any, emailData: any): void;
    RefundApptCharge(payment_id: any, PatientChargesDetailsId: any, AdminPatientChargesDetailsId: any): void;
    RefundTempApptCharge(payment_id: string): void;
    TransferToSubmerchant(payment_id: any, getPaymentGatewayDetails: any): Promise<void>;
    sendnotificationApptDeleteEvent(verifyData: any, emailData: any): void;
    sendnotificationTempApptCreateEvent(verifyData: any, emailData: any): void;
    sendnotificationApptUpdateEvent(verifyData: any, emailData: any): void;
    create(AppointmentEntity: AddAppointment): Promise<any>;
    findAll(): Promise<AddAppointment[]>;
    findOne(id: string, hospital_id: number): Promise<any>;
    update(numb: number, Entity: AddAppointment): Promise<any>;
    remove(id: string, hos_id: number): Promise<{
        [key: string]: any;
    }[]>;
    set_status_to_approved(appointment_id: number, hos_id: number): Promise<{
        status: string;
        message: string;
    }>;
    cancelAppointment(id: string, Entity: AddAppointment): Promise<{
        status: string;
        message: string;
    }[]>;
    findappointment(limit: number, page: number, filter?: string, search?: string, hospital_id?: number): Promise<CountDto>;
    V3findappointment(limit: number, page: number, filter?: string, search?: string, hospital_id?: number): Promise<{
        details: any;
        count: any;
    }>;
    updatePaymentDetails(appointment_id: number, Entity: AddAppointmentPayment): Promise<{
        status_code: number;
        status: string;
        message: string;
    }[] | {
        status_code: number;
        status: string;
        message: string;
    }>;
    getPatAppoint(aayush_unique_id: number): Promise<{
        statusCode: number;
        status: string;
        message: string;
        data?: undefined;
    } | {
        statusCode: number;
        status: string;
        message: string;
        data: any;
    }>;
}
